/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.model;

import com.blackduck.integration.blackduck.api.generated.enumeration.ProjectCloneCategoriesType;
import com.blackduck.integration.blackduck.api.generated.enumeration.ProjectVersionDistributionType;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionLicenseLicensesView;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionLicenseView;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionView;
import com.blackduck.integration.blackduck.api.manual.temporary.component.ComplexLicenseRequest;
import com.blackduck.integration.blackduck.api.manual.temporary.component.ProjectRequest;
import com.blackduck.integration.blackduck.api.manual.temporary.component.ProjectVersionRequest;
import com.blackduck.integration.blackduck.api.manual.temporary.enumeration.ProjectVersionPhaseType;
import com.blackduck.integration.blackduck.api.manual.view.ProjectView;
import com.blackduck.integration.util.NameVersion;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ProjectSyncModel {
    private static final Set<String> IGNORED_REQUEST_FIELDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("versionRequest", "license")));
    private static final Set<Field> ALL_FIELDS = new HashSet<Field>();
    public static final Field CLONE_CATEGORIES_FIELD = ProjectSyncModel.getFieldSafely("cloneCategories");
    public static final Field CUSTOM_SIGNATURE_ENABLED_FIELD = ProjectSyncModel.getFieldSafely("customSignatureEnabled");
    public static final Field DEEP_LICENSE_DATA_ENABLED_FIELD = ProjectSyncModel.getFieldSafely("deepLicenseDataEnabled");
    public static final Field DEEP_LICENSE_DATA_SNIPPET_ENABLED_FIELD = ProjectSyncModel.getFieldSafely("deepLicenseDataSnippetEnabled");
    public static final Field DESCRIPTION_FIELD = ProjectSyncModel.getFieldSafely("description");
    public static final Field NAME_FIELD = ProjectSyncModel.getFieldSafely("name");
    public static final Field PROJECT_LEVEL_ADJUSTMENTS_FIELD = ProjectSyncModel.getFieldSafely("projectLevelAdjustments");
    public static final Field PROJECT_OWNER_FIELD = ProjectSyncModel.getFieldSafely("projectOwner");
    public static final Field PROJECT_TIER_FIELD = ProjectSyncModel.getFieldSafely("projectTier");
    public static final Field PROJECT_GROUP_FIELD = ProjectSyncModel.getFieldSafely("projectGroup");
    public static final Field CLONE_FROM_RELEASE_URL_FIELD = ProjectSyncModel.getFieldSafely("cloneFromReleaseUrl");
    public static final Field DISTRIBUTION_FIELD = ProjectSyncModel.getFieldSafely("distribution");
    public static final Field NICKNAME_FIELD = ProjectSyncModel.getFieldSafely("nickname");
    public static final Field PHASE_FIELD = ProjectSyncModel.getFieldSafely("phase");
    public static final Field RELEASE_COMMENTS_FIELD = ProjectSyncModel.getFieldSafely("releaseComments");
    public static final Field RELEASED_ON_FIELD = ProjectSyncModel.getFieldSafely("releasedOn");
    public static final Field VERSION_NAME_FIELD = ProjectSyncModel.getFieldSafely("versionName");
    public static final Field UPDATE_FIELD = ProjectSyncModel.getFieldSafely("update");
    public static final Field VERSION_LICENSE_URL_FIELD = ProjectSyncModel.getFieldSafely("versionLicenseUrl");
    private List<ProjectCloneCategoriesType> cloneCategories;
    private Boolean customSignatureEnabled;
    private Boolean deepLicenseDataEnabled;
    private Boolean deepLicenseDataSnippetEnabled;
    private String description;
    private String name;
    private Boolean projectLevelAdjustments;
    private String projectOwner;
    private Integer projectTier;
    private String projectGroup;
    private String cloneFromReleaseUrl;
    private ProjectVersionDistributionType distribution;
    private String nickname;
    private ProjectVersionPhaseType phase;
    private String releaseComments;
    private Date releasedOn;
    private String versionName;
    private Boolean update;
    private String versionLicenseUrl;
    private final Set<Field> fieldsWithSetValues = new HashSet<Field>();

    private static Field getFieldSafely(String fieldName) {
        try {
            Field field = ProjectSyncModel.class.getDeclaredField(fieldName);
            ALL_FIELDS.add(field);
            return field;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ProjectSyncModel createWithDefaults(String projectName, String projectVersionName) {
        return ProjectSyncModel.createWithDefaults(new NameVersion(projectName, projectVersionName));
    }

    public static ProjectSyncModel createWithDefaults(NameVersion projectAndVersion) {
        ProjectSyncModel projectSyncModel = new ProjectSyncModel(projectAndVersion);
        projectSyncModel.setDistribution(ProjectVersionDistributionType.EXTERNAL);
        projectSyncModel.setPhase(ProjectVersionPhaseType.DEVELOPMENT);
        return projectSyncModel;
    }

    public ProjectSyncModel() {
    }

    public ProjectSyncModel(String projectName, String projectVersionName) {
        this(new NameVersion(projectName, projectVersionName));
    }

    public ProjectSyncModel(NameVersion projectAndVersion) {
        this.setName(projectAndVersion.getName());
        this.setVersionName(projectAndVersion.getVersion());
    }

    public ProjectRequest createProjectRequest() {
        ProjectRequest projectRequest = new ProjectRequest();
        projectRequest.setName(this.name);
        projectRequest.setDescription(this.description);
        projectRequest.setProjectLevelAdjustments(this.projectLevelAdjustments);
        projectRequest.setProjectOwner(this.projectOwner);
        projectRequest.setProjectTier(this.projectTier);
        projectRequest.setProjectGroup(this.projectGroup);
        projectRequest.setCloneCategories(this.cloneCategories);
        projectRequest.setCustomSignatureEnabled(this.customSignatureEnabled);
        projectRequest.setDeepLicenseDataEnabled(this.deepLicenseDataEnabled);
        projectRequest.setDeepLicenseDataSnippetEnabled(this.deepLicenseDataSnippetEnabled);
        projectRequest.setVersionRequest(this.createProjectVersionRequest());
        return projectRequest;
    }

    public ProjectVersionRequest createProjectVersionRequest() {
        ProjectVersionRequest projectVersionRequest = new ProjectVersionRequest();
        projectVersionRequest.setDistribution(this.distribution);
        projectVersionRequest.setPhase(this.phase);
        projectVersionRequest.setVersionName(this.versionName);
        projectVersionRequest.setReleaseComments(this.releaseComments);
        projectVersionRequest.setCloneFromReleaseUrl(this.cloneFromReleaseUrl);
        projectVersionRequest.setReleasedOn(this.releasedOn);
        projectVersionRequest.setNickname(this.nickname);
        projectVersionRequest.setUpdate(this.update);
        if (this.fieldSet(VERSION_LICENSE_URL_FIELD)) {
            projectVersionRequest.setLicense(this.createComplexLicenseRequest());
        }
        return projectVersionRequest;
    }

    public ComplexLicenseRequest createComplexLicenseRequest() {
        ComplexLicenseRequest complexLicenseRequest = new ComplexLicenseRequest();
        complexLicenseRequest.setLicense(this.versionLicenseUrl);
        return complexLicenseRequest;
    }

    public void populateProjectView(ProjectView projectView) {
        if (this.fieldSet(CLONE_CATEGORIES_FIELD)) {
            projectView.setCloneCategories(this.cloneCategories);
        }
        if (this.fieldSet(CUSTOM_SIGNATURE_ENABLED_FIELD)) {
            projectView.setCustomSignatureEnabled(this.customSignatureEnabled);
        }
        if (this.fieldSet(DEEP_LICENSE_DATA_ENABLED_FIELD)) {
            projectView.setDeepLicenseDataEnabledEnabled(this.deepLicenseDataEnabled);
        }
        if (this.fieldSet(DEEP_LICENSE_DATA_SNIPPET_ENABLED_FIELD)) {
            projectView.setDeepLicenseDataSnippetEnabled(this.deepLicenseDataSnippetEnabled);
        }
        if (this.fieldSet(DESCRIPTION_FIELD)) {
            projectView.setDescription(this.description);
        }
        if (this.fieldSet(NAME_FIELD)) {
            projectView.setName(this.name);
        }
        if (this.fieldSet(PROJECT_LEVEL_ADJUSTMENTS_FIELD)) {
            projectView.setProjectLevelAdjustments(this.projectLevelAdjustments);
        }
        if (this.fieldSet(PROJECT_OWNER_FIELD)) {
            projectView.setProjectOwner(this.projectOwner);
        }
        if (this.fieldSet(PROJECT_TIER_FIELD)) {
            projectView.setProjectTier(this.projectTier);
        }
        if (this.fieldSet(PROJECT_GROUP_FIELD)) {
            projectView.setProjectGroup(this.projectGroup);
        }
    }

    public void populateProjectVersionView(ProjectVersionView projectVersionView) {
        if (this.fieldSet(DISTRIBUTION_FIELD)) {
            projectVersionView.setDistribution(this.distribution);
        }
        if (this.fieldSet(NICKNAME_FIELD)) {
            projectVersionView.setNickname(this.nickname);
        }
        if (this.fieldSet(PHASE_FIELD)) {
            projectVersionView.setPhase(this.phase);
        }
        if (this.fieldSet(RELEASE_COMMENTS_FIELD)) {
            projectVersionView.setReleaseComments(this.releaseComments);
        }
        if (this.fieldSet(RELEASED_ON_FIELD)) {
            projectVersionView.setReleasedOn(this.releasedOn);
        }
        if (this.fieldSet(VERSION_NAME_FIELD)) {
            projectVersionView.setVersionName(this.versionName);
        }
        if (this.fieldSet(VERSION_LICENSE_URL_FIELD)) {
            projectVersionView.setLicense(this.createProjectVersionLicense(projectVersionView.getLicense(), this.versionLicenseUrl));
        }
    }

    private ProjectVersionLicenseView createProjectVersionLicense(ProjectVersionLicenseView currentLicense, String licenseUrl) {
        ProjectVersionLicenseView projectVersionLicenseView = currentLicense != null ? currentLicense : new ProjectVersionLicenseView();
        LinkedList<ProjectVersionLicenseLicensesView> licenses = new LinkedList<ProjectVersionLicenseLicensesView>();
        ProjectVersionLicenseLicensesView projectVersionLicenseLicensesView = new ProjectVersionLicenseLicensesView();
        projectVersionLicenseLicensesView.setLicense(licenseUrl);
        licenses.add(projectVersionLicenseLicensesView);
        projectVersionLicenseView.setLicenses(licenses);
        return projectVersionLicenseView;
    }

    public boolean shouldHandleProjectVersion() {
        return this.fieldsWithSetValues.contains(VERSION_NAME_FIELD) && StringUtils.isNotBlank((CharSequence)this.versionName);
    }

    public List<ProjectCloneCategoriesType> getCloneCategories() {
        return this.cloneCategories;
    }

    public void setCloneCategories(List<ProjectCloneCategoriesType> cloneCategories) {
        this.cloneCategories = cloneCategories;
        this.fieldsWithSetValues.add(CLONE_CATEGORIES_FIELD);
    }

    public Boolean getCustomSignatureEnabled() {
        return this.customSignatureEnabled;
    }

    public void setCustomSignatureEnabled(Boolean customSignatureEnabled) {
        this.customSignatureEnabled = customSignatureEnabled;
        this.fieldsWithSetValues.add(CUSTOM_SIGNATURE_ENABLED_FIELD);
    }

    public Boolean getDeepLicenseDataEnabled() {
        return this.deepLicenseDataEnabled;
    }

    public void setDeepLicenseDataEnabled(Boolean deepLicenseDataEnabled) {
        this.deepLicenseDataEnabled = deepLicenseDataEnabled;
        this.fieldsWithSetValues.add(DEEP_LICENSE_DATA_ENABLED_FIELD);
    }

    public Boolean getDeepLicenseDataSnippetEnabled() {
        return this.deepLicenseDataSnippetEnabled;
    }

    public void setDeepLicenseDataSnippetEnabled(Boolean deepLicenseDataSnippetEnabled) {
        this.deepLicenseDataSnippetEnabled = deepLicenseDataSnippetEnabled;
        this.fieldsWithSetValues.add(DEEP_LICENSE_DATA_SNIPPET_ENABLED_FIELD);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fieldsWithSetValues.add(DESCRIPTION_FIELD);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fieldsWithSetValues.add(NAME_FIELD);
    }

    public Boolean getProjectLevelAdjustments() {
        return this.projectLevelAdjustments;
    }

    public void setProjectLevelAdjustments(Boolean projectLevelAdjustments) {
        this.projectLevelAdjustments = projectLevelAdjustments;
        this.fieldsWithSetValues.add(PROJECT_LEVEL_ADJUSTMENTS_FIELD);
    }

    public String getProjectOwner() {
        return this.projectOwner;
    }

    public void setProjectOwner(String projectOwner) {
        this.projectOwner = projectOwner;
        this.fieldsWithSetValues.add(PROJECT_OWNER_FIELD);
    }

    public Integer getProjectTier() {
        return this.projectTier;
    }

    public void setProjectTier(Integer projectTier) {
        this.projectTier = projectTier;
        this.fieldsWithSetValues.add(PROJECT_TIER_FIELD);
    }

    public String getProjectGroup() {
        return this.projectGroup;
    }

    public void setProjectGroup(String projectGroup) {
        this.projectGroup = projectGroup;
        this.fieldsWithSetValues.add(PROJECT_GROUP_FIELD);
    }

    public String getCloneFromReleaseUrl() {
        return this.cloneFromReleaseUrl;
    }

    public void setCloneFromReleaseUrl(String cloneFromReleaseUrl) {
        this.cloneFromReleaseUrl = cloneFromReleaseUrl;
        this.fieldsWithSetValues.add(CLONE_FROM_RELEASE_URL_FIELD);
    }

    public ProjectVersionDistributionType getDistribution() {
        return this.distribution;
    }

    public void setDistribution(ProjectVersionDistributionType distribution) {
        this.distribution = distribution;
        this.fieldsWithSetValues.add(DISTRIBUTION_FIELD);
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
        this.fieldsWithSetValues.add(NICKNAME_FIELD);
    }

    public ProjectVersionPhaseType getPhase() {
        return this.phase;
    }

    public void setPhase(ProjectVersionPhaseType phase) {
        this.phase = phase;
        this.fieldsWithSetValues.add(PHASE_FIELD);
    }

    public String getReleaseComments() {
        return this.releaseComments;
    }

    public void setReleaseComments(String releaseComments) {
        this.releaseComments = releaseComments;
        this.fieldsWithSetValues.add(RELEASE_COMMENTS_FIELD);
    }

    public Date getReleasedOn() {
        return this.releasedOn;
    }

    public void setReleasedOn(Date releasedOn) {
        this.releasedOn = releasedOn;
        this.fieldsWithSetValues.add(RELEASED_ON_FIELD);
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
        this.fieldsWithSetValues.add(VERSION_NAME_FIELD);
    }

    private boolean fieldSet(Field field) {
        return this.fieldsWithSetValues.contains(field);
    }

    public String getVersionLicenseUrl() {
        return this.versionLicenseUrl;
    }

    public void setVersionLicenseUrl(String versionLicenseUrl) {
        this.versionLicenseUrl = versionLicenseUrl;
        this.fieldsWithSetValues.add(VERSION_LICENSE_URL_FIELD);
    }

    public Boolean getUpdate() {
        return this.update;
    }

    public void setUpdate(Boolean update) {
        this.update = update;
        this.fieldsWithSetValues.add(UPDATE_FIELD);
    }
}

