/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.model;

import com.blackduck.integration.blackduck.api.enumeration.RankedSeverityType;
import com.blackduck.integration.blackduck.api.generated.component.ProjectVersionPolicyStatusComponentVersionPolicyViolationDetailsView;
import com.blackduck.integration.blackduck.api.generated.enumeration.PolicyRuleSeverityType;
import com.blackduck.integration.blackduck.api.generated.enumeration.ProjectVersionComponentPolicyStatusType;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionPolicyStatusView;
import com.blackduck.integration.blackduck.api.manual.temporary.component.NameValuePairView;
import com.blackduck.integration.blackduck.service.model.ComponentVersionPolicyViolationCount;
import com.blackduck.integration.blackduck.service.model.ComponentVersionStatusCount;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PolicyStatusDescription {
    private final ProjectVersionPolicyStatusView policyStatusItem;
    private final Map<ProjectVersionComponentPolicyStatusType, ComponentVersionStatusCount> policyStatusCount = new HashMap<ProjectVersionComponentPolicyStatusType, ComponentVersionStatusCount>();
    private final Map<PolicyRuleSeverityType, ComponentVersionPolicyViolationCount> policySeverityCount = new HashMap<PolicyRuleSeverityType, ComponentVersionPolicyViolationCount>();

    public PolicyStatusDescription(ProjectVersionPolicyStatusView policyStatusItem) {
        this.policyStatusItem = policyStatusItem;
        this.populatePolicySeverityMap();
        this.populatePolicyStatusMap();
    }

    private void populatePolicySeverityMap() {
        List nameValuePairs;
        ProjectVersionPolicyStatusComponentVersionPolicyViolationDetailsView policyViolationDetails = this.policyStatusItem.getComponentVersionPolicyViolationDetails();
        if (policyViolationDetails != null && ProjectVersionComponentPolicyStatusType.IN_VIOLATION.equals((Object)this.policyStatusItem.getOverallStatus()) && (nameValuePairs = policyViolationDetails.getSeverityLevels()) != null) {
            for (NameValuePairView nameValuePairView : nameValuePairs) {
                if (nameValuePairView.getName() == null) continue;
                ComponentVersionPolicyViolationCount componentVersionPolicyViolationCount = new ComponentVersionPolicyViolationCount(nameValuePairView);
                this.policySeverityCount.put(componentVersionPolicyViolationCount.name, componentVersionPolicyViolationCount);
            }
        }
    }

    private void populatePolicyStatusMap() {
        List nameValuePairs = this.policyStatusItem.getComponentVersionStatusCounts();
        if (nameValuePairs != null) {
            for (NameValuePairView nameValuePairView : nameValuePairs) {
                if (nameValuePairView.getName() == null) continue;
                ComponentVersionStatusCount componentVersionStatusCount = new ComponentVersionStatusCount(nameValuePairView);
                this.policyStatusCount.put(componentVersionStatusCount.name, componentVersionStatusCount);
            }
        }
    }

    public String getPolicyStatusMessage() {
        if (this.policyStatusItem.getComponentVersionStatusCounts() == null || this.policyStatusItem.getComponentVersionStatusCounts().size() == 0) {
            return "Black Duck found no components.";
        }
        int inViolationCount = this.getCountOfStatus(ProjectVersionComponentPolicyStatusType.IN_VIOLATION);
        int inViolationOverriddenCount = this.getCountOfStatus(ProjectVersionComponentPolicyStatusType.IN_VIOLATION_OVERRIDDEN);
        int notInViolationCount = this.getCountOfStatus(ProjectVersionComponentPolicyStatusType.NOT_IN_VIOLATION);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Black Duck found:");
        stringBuilder.append(this.fixComponentPlural(" %d %s in violation", inViolationCount));
        if (this.getCountOfStatus(ProjectVersionComponentPolicyStatusType.IN_VIOLATION) > 0) {
            stringBuilder.append(" (");
            this.getPolicySeverityMessage(stringBuilder);
            stringBuilder.append(")");
        }
        stringBuilder.append(",");
        stringBuilder.append(this.fixComponentPlural(" %d %s in violation, but overridden, and", inViolationOverriddenCount));
        stringBuilder.append(this.fixComponentPlural(" %d %s not in violation.", notInViolationCount));
        return stringBuilder.toString();
    }

    private void getPolicySeverityMessage(StringBuilder stringBuilder) {
        stringBuilder.append("Policy Severity counts: ");
        String policySeverityItems = RankedSeverityType.getRankedValues().stream().filter(this.policySeverityCount::containsKey).map(policyRuleSeverityType -> this.fixMatchPlural("%d %s a severity level of %s", this.policySeverityCount.get((Object)policyRuleSeverityType).value, (PolicyRuleSeverityType)policyRuleSeverityType)).collect(Collectors.joining(", "));
        stringBuilder.append(policySeverityItems);
    }

    public ComponentVersionStatusCount getCountInViolation() {
        return this.policyStatusCount.get(ProjectVersionComponentPolicyStatusType.IN_VIOLATION);
    }

    public ComponentVersionStatusCount getCountNotInViolation() {
        return this.policyStatusCount.get(ProjectVersionComponentPolicyStatusType.NOT_IN_VIOLATION);
    }

    public ComponentVersionStatusCount getCountInViolationOverridden() {
        return this.policyStatusCount.get(ProjectVersionComponentPolicyStatusType.IN_VIOLATION_OVERRIDDEN);
    }

    public int getCountOfStatus(ProjectVersionComponentPolicyStatusType overallStatus) {
        ComponentVersionStatusCount count = this.policyStatusCount.get(overallStatus);
        if (count == null) {
            return 0;
        }
        return count.value;
    }

    public int getCountOfSeverity(PolicyRuleSeverityType severity) {
        ComponentVersionPolicyViolationCount count = this.policySeverityCount.get(severity);
        if (count == null) {
            return 0;
        }
        return count.value;
    }

    private String fixComponentPlural(String formatString, int count) {
        String label = "components";
        if (count == 1) {
            label = "component";
        }
        return String.format(formatString, count, label);
    }

    private String fixMatchPlural(String formatString, int count, PolicyRuleSeverityType policyRuleSeverityType) {
        String label = "matches have";
        if (count == 1) {
            label = "match has";
        }
        return String.format(formatString, count, label, policyRuleSeverityType);
    }
}

