/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.model;

import com.blackduck.integration.blackduck.api.enumeration.PolicyRuleComponentUsageValueSetType;
import com.blackduck.integration.blackduck.api.enumeration.PolicyRuleConditionOperatorType;
import com.blackduck.integration.blackduck.api.enumeration.PolicyRuleConditionType;
import com.blackduck.integration.blackduck.api.enumeration.ReviewStatusType;
import com.blackduck.integration.blackduck.api.generated.component.PolicyRuleExpressionExpressionsParametersView;
import com.blackduck.integration.blackduck.api.generated.component.PolicyRuleExpressionExpressionsView;
import com.blackduck.integration.blackduck.api.generated.component.PolicyRuleExpressionView;
import com.blackduck.integration.blackduck.api.generated.enumeration.PolicyRuleExpressionOperatorType;
import com.blackduck.integration.blackduck.api.generated.enumeration.ProjectVersionDistributionType;
import com.blackduck.integration.blackduck.api.generated.view.ComponentVersionView;
import com.blackduck.integration.blackduck.api.generated.view.ComponentView;
import com.blackduck.integration.blackduck.api.generated.view.LicenseView;
import com.blackduck.integration.blackduck.api.manual.temporary.enumeration.ProjectVersionPhaseType;
import com.blackduck.integration.blackduck.api.manual.view.ProjectView;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.RestConstants;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PolicyRuleExpressionSetBuilder {
    private final List<PolicyRuleExpressionExpressionsView> expressions = new ArrayList<PolicyRuleExpressionExpressionsView>();

    public void addProjectCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, ProjectView projectView) throws BlackDuckIntegrationException {
        this.addSingleCondition(policyRuleConditionOperator, PolicyRuleConditionType.PROJECT_NAME, projectView.getHref());
    }

    public void addComponentVersionCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, ComponentVersionView componentVersionView) throws BlackDuckIntegrationException {
        this.addSingleCondition(policyRuleConditionOperator, PolicyRuleConditionType.SINGLE_VERSION, componentVersionView.getHref());
    }

    public void addComponentCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, ComponentView componentView) throws BlackDuckIntegrationException {
        this.addSingleCondition(policyRuleConditionOperator, PolicyRuleConditionType.SINGLE_VERSION, componentView.getHref());
    }

    public void addLicenseCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, LicenseView licenseView) throws BlackDuckIntegrationException {
        this.addSingleCondition(policyRuleConditionOperator, PolicyRuleConditionType.SINGLE_LICENSE, licenseView.getHref());
    }

    public void addReviewStatusCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, ReviewStatusType reviewType) throws BlackDuckIntegrationException {
        this.addSingleObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.REVIEW_STATUS, (Object)reviewType);
    }

    public void addComponentReleaseDateCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, Date date) throws BlackDuckIntegrationException {
        this.addSingleCondition(policyRuleConditionOperator, PolicyRuleConditionType.RELEASE_DATE, RestConstants.formatDate((Date)date));
    }

    public void addNewerVersionCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, Integer count) throws BlackDuckIntegrationException {
        this.addSingleObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.NEWER_VERSIONS_COUNT, count);
    }

    public void addHighSeverityVulnerabilityCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, Integer count) throws BlackDuckIntegrationException {
        this.addSingleObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.HIGH_SEVERITY_VULN_COUNT, count);
    }

    public void addMediumSeverityVulnerabilityCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, Integer count) throws BlackDuckIntegrationException {
        this.addSingleObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.MEDIUM_SEVERITY_VULN_COUNT, count);
    }

    public void addLowSeverityVulnerabilityCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, Integer count) throws BlackDuckIntegrationException {
        this.addSingleObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.LOW_SEVERITY_VULN_COUNT, count);
    }

    public void addProjectTierCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, List<Integer> tiers) throws BlackDuckIntegrationException {
        this.addMultiObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.PROJECT_TIER, tiers);
    }

    public void addPhaseCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, List<ProjectVersionPhaseType> projectVersionPhaseTypes) throws BlackDuckIntegrationException {
        this.addMultiObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.VERSION_PHASE, projectVersionPhaseTypes);
    }

    public void addDistributionCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, List<ProjectVersionDistributionType> ProjectVersionDistributionTypes) throws BlackDuckIntegrationException {
        this.addMultiObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.VERSION_DISTRIBUTION, ProjectVersionDistributionTypes);
    }

    public void addComponentUsageCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, List<PolicyRuleComponentUsageValueSetType> componentUsageTypes) throws BlackDuckIntegrationException {
        this.addMultiObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.COMPONENT_USAGE, componentUsageTypes);
    }

    public void addVulnerabilityOverallScoreCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, BigDecimal overallScore) throws BlackDuckIntegrationException {
        this.addSingleCondition(policyRuleConditionOperator, PolicyRuleConditionType.VULN_LEVEL_OVERALL_SCORE, overallScore.toString());
    }

    public void addSingleObjectCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, PolicyRuleConditionType policyRuleConditionType, Object object) throws BlackDuckIntegrationException {
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(object.toString());
        this.addMultiCondition(policyRuleConditionOperator, policyRuleConditionType, values);
    }

    public void addMultiObjectCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, PolicyRuleConditionType policyRuleConditionType, List<?> objectValues) throws BlackDuckIntegrationException {
        ArrayList<String> values = new ArrayList<String>(objectValues.size());
        for (Object object : objectValues) {
            values.add(object.toString());
        }
        this.addMultiCondition(policyRuleConditionOperator, policyRuleConditionType, values);
    }

    public void addSingleCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, PolicyRuleConditionType policyRuleConditionType, HttpUrl httpUrl) throws BlackDuckIntegrationException {
        this.addSingleCondition(policyRuleConditionOperator, policyRuleConditionType, httpUrl.string());
    }

    public void addSingleCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, PolicyRuleConditionType policyRuleConditionType, String value) throws BlackDuckIntegrationException {
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(value);
        this.addMultiCondition(policyRuleConditionOperator, policyRuleConditionType, values);
    }

    public void addMultiCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, PolicyRuleConditionType policyRuleConditionType, List<String> values) throws BlackDuckIntegrationException {
        PolicyRuleExpressionExpressionsParametersView expressionParameter = new PolicyRuleExpressionExpressionsParametersView();
        expressionParameter.setValues(values);
        PolicyRuleExpressionExpressionsView expression = new PolicyRuleExpressionExpressionsView();
        expression.setName(policyRuleConditionType.toString());
        expression.setOperation(policyRuleConditionOperator.toString());
        expression.setParameters(expressionParameter);
        this.expressions.add(expression);
    }

    public PolicyRuleExpressionView createPolicyRuleExpressionView() {
        return this.createPolicyRuleExpressionView(PolicyRuleExpressionOperatorType.AND);
    }

    public PolicyRuleExpressionView createPolicyRuleExpressionView(PolicyRuleExpressionOperatorType expressionOperatorType) {
        PolicyRuleExpressionView expressionSet = new PolicyRuleExpressionView();
        expressionSet.setOperator(expressionOperatorType);
        expressionSet.setExpressions(this.expressions);
        return expressionSet;
    }
}

