/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.dataservice;

import com.blackduck.integration.blackduck.api.core.BlackDuckComponent;
import com.blackduck.integration.blackduck.api.core.response.UrlMultipleResponses;
import com.blackduck.integration.blackduck.api.core.response.UrlSingleResponse;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.generated.view.UserView;
import com.blackduck.integration.blackduck.api.manual.temporary.component.UserRequest;
import com.blackduck.integration.blackduck.http.BlackDuckPageDefinition;
import com.blackduck.integration.blackduck.http.BlackDuckPageResponse;
import com.blackduck.integration.blackduck.http.BlackDuckQuery;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.blackduck.service.request.BlackDuckMultipleRequest;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import java.util.List;
import java.util.Optional;

public class UserService
extends DataService {
    private final UrlSingleResponse<UserView> currentUserResponse;
    private final UrlMultipleResponses<UserView> usersResponse;

    public UserService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger) {
        super(blackDuckApiClient, apiDiscovery, logger);
        this.currentUserResponse = this.apiDiscovery.metaSingleResponse(ApiDiscovery.CURRENT_USER_PATH);
        this.usersResponse = this.apiDiscovery.metaMultipleResponses(ApiDiscovery.USERS_PATH);
    }

    public UserRequest createUserRequest(String username, String password, String firstName, String lastName) {
        UserRequest userRequest = new UserRequest();
        userRequest.setUserName(username);
        userRequest.setPassword(password);
        userRequest.setFirstName(firstName);
        userRequest.setLastName(lastName);
        userRequest.setActive(Boolean.valueOf(true));
        return userRequest;
    }

    public UserView createUser(UserRequest userRequest) throws IntegrationException {
        HttpUrl createUserUrl = this.apiDiscovery.getUrl(ApiDiscovery.USERS_PATH);
        HttpUrl userUrl = this.blackDuckApiClient.post(createUserUrl, (BlackDuckComponent)userRequest);
        return this.blackDuckApiClient.getResponse(userUrl, UserView.class);
    }

    public UserView findCurrentUser() throws IntegrationException {
        return this.blackDuckApiClient.getResponse(this.currentUserResponse);
    }

    public BlackDuckPageResponse<UserView> findUsersByEmail(String emailSearchTerm, BlackDuckPageDefinition blackDuckPageDefinition) throws IntegrationException {
        BlackDuckQuery emailQuery = new BlackDuckQuery("email", emailSearchTerm);
        BlackDuckRequestBuilder blackDuckRequestBuilder = new BlackDuckRequestBuilder().commonGet().addBlackDuckQuery(emailQuery).setBlackDuckPageDefinition(blackDuckPageDefinition);
        BlackDuckMultipleRequest<UserView> requestMultiple = blackDuckRequestBuilder.buildBlackDuckRequest(this.usersResponse);
        return this.blackDuckApiClient.getPageResponse(requestMultiple);
    }

    public Optional<UserView> findUserByUsername(String username) throws IntegrationException {
        BlackDuckQuery usernameQuery = new BlackDuckQuery("userName", username);
        BlackDuckRequestBuilder blackDuckRequestBuilder = new BlackDuckRequestBuilder().commonGet().addBlackDuckQuery(usernameQuery);
        BlackDuckMultipleRequest<UserView> requestMultiple = blackDuckRequestBuilder.buildBlackDuckRequest(this.usersResponse);
        List foundUsers = this.blackDuckApiClient.getSomeResponses(requestMultiple, 1);
        return foundUsers.stream().findFirst();
    }

    public List<UserView> getAllUsers() throws IntegrationException {
        return this.blackDuckApiClient.getAllResponses(this.usersResponse);
    }

    public BlackDuckPageResponse<UserView> getPageOfUsers(BlackDuckPageDefinition blackDuckPageDefinition) throws IntegrationException {
        BlackDuckRequestBuilder blackDuckRequestBuilder = new BlackDuckRequestBuilder().commonGet().setBlackDuckPageDefinition(blackDuckPageDefinition);
        BlackDuckMultipleRequest<UserView> requestMultiple = blackDuckRequestBuilder.buildBlackDuckRequest(this.usersResponse);
        return this.blackDuckApiClient.getPageResponse(requestMultiple);
    }
}

