/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.dataservice;

import com.blackduck.integration.blackduck.api.core.BlackDuckComponent;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.generated.response.AssignedProjectView;
import com.blackduck.integration.blackduck.api.generated.view.RoleAssignmentView;
import com.blackduck.integration.blackduck.api.generated.view.UserGroupView;
import com.blackduck.integration.blackduck.api.generated.view.UserView;
import com.blackduck.integration.blackduck.api.manual.temporary.component.UserGroupRequest;
import com.blackduck.integration.blackduck.api.manual.view.ProjectView;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.blackduck.service.dataservice.RoleService;
import com.blackduck.integration.blackduck.service.request.BlackDuckMultipleRequest;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class UserGroupService
extends DataService {
    public static final BiPredicate<String, UserView> MATCHING_USERNAME = (username, userView) -> username.equalsIgnoreCase(userView.getUserName());

    public UserGroupService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger) {
        super(blackDuckApiClient, apiDiscovery, logger);
    }

    public UserGroupView createUserGroup(UserGroupRequest userGroupRequest) throws IntegrationException {
        HttpUrl userGroupUrl = this.blackDuckApiClient.post(this.apiDiscovery.metaUsergroupsLink().getUrl(), (BlackDuckComponent)userGroupRequest);
        UserGroupView userGroupView = this.blackDuckApiClient.getResponse(userGroupUrl, UserGroupView.class);
        return userGroupView;
    }

    public Optional<UserView> getUserByUsername(String username) throws IntegrationException {
        Predicate<UserView> predicate = userView -> MATCHING_USERNAME.test(username, (UserView)userView);
        List<UserView> matchingUsers = this.blackDuckApiClient.getSomeMatchingResponses(this.apiDiscovery.metaUsersLink(), predicate, 1);
        if (!matchingUsers.isEmpty()) {
            return Optional.ofNullable(matchingUsers.get(0));
        }
        this.logger.error(String.format("The user (%s) does not exist.", username));
        return Optional.empty();
    }

    public List<ProjectView> getProjectsForUser(String username) throws IntegrationException {
        Optional<UserView> user = this.getUserByUsername(username);
        if (!user.isPresent()) {
            return Collections.emptyList();
        }
        return this.getProjectsForUser(user.get());
    }

    public List<ProjectView> getProjectsForUser(UserView userView) throws IntegrationException {
        this.logger.debug("Attempting to get the assigned projects for User: " + userView.getUserName());
        List assignedProjectViews = this.blackDuckApiClient.getAllResponses(userView.metaProjectsLink());
        ArrayList<ProjectView> resolvedProjectViews = new ArrayList<ProjectView>();
        for (AssignedProjectView assigned : assignedProjectViews) {
            HttpUrl projectUrl = new HttpUrl(assigned.getProject());
            ProjectView project = this.blackDuckApiClient.getResponse(projectUrl, ProjectView.class);
            if (project == null) continue;
            resolvedProjectViews.add(project);
        }
        return resolvedProjectViews;
    }

    public List<RoleAssignmentView> getRolesForUser(String username) throws IntegrationException {
        Optional<UserView> user = this.getUserByUsername(username);
        if (!user.isPresent()) {
            return Collections.emptyList();
        }
        return this.getRolesForUser(user.get());
    }

    public List<RoleAssignmentView> getRolesForUser(UserView userView) throws IntegrationException {
        return this.blackDuckApiClient.getAllResponses(userView.metaRolesLink());
    }

    public List<RoleAssignmentView> getInheritedRolesForUser(String username) throws IntegrationException {
        Optional<UserView> user = this.getUserByUsername(username);
        if (!user.isPresent()) {
            return Collections.emptyList();
        }
        return this.getInheritedRolesForUser(user.get());
    }

    public List<RoleAssignmentView> getInheritedRolesForUser(UserView userView) throws IntegrationException {
        return this.blackDuckApiClient.getAllResponses(userView.metaInheritedRolesLink());
    }

    public List<RoleAssignmentView> getAllRolesForUser(String username) throws IntegrationException {
        Optional<UserView> user = this.getUserByUsername(username);
        if (!user.isPresent()) {
            return Collections.emptyList();
        }
        return this.getAllRolesForUser(user.get());
    }

    public List<RoleAssignmentView> getAllRolesForUser(UserView userView) throws IntegrationException {
        LinkedHashSet<RoleAssignmentView> roleSet = new LinkedHashSet<RoleAssignmentView>();
        roleSet.addAll(this.getRolesForUser(userView));
        roleSet.addAll(this.getInheritedRolesForUser(userView));
        return new ArrayList<RoleAssignmentView>(roleSet);
    }

    public List<RoleAssignmentView> getServerRolesForUser(UserView userView) throws IntegrationException {
        BlackDuckRequestBuilder blackDuckRequestBuilder = new BlackDuckRequestBuilder().commonGet().addBlackDuckFilter(RoleService.createScopeFilter("server"));
        BlackDuckMultipleRequest requestMultiple = blackDuckRequestBuilder.buildBlackDuckRequest(userView.metaRolesLink());
        return this.blackDuckApiClient.getAllResponses(requestMultiple);
    }

    public Optional<UserGroupView> getGroupByName(String groupName) throws IntegrationException {
        List allGroups = this.blackDuckApiClient.getAllResponses(this.apiDiscovery.metaUsergroupsLink());
        for (UserGroupView group : allGroups) {
            if (!group.getName().equalsIgnoreCase(groupName)) continue;
            return Optional.of(group);
        }
        this.logger.error(String.format("The group (%s) does not exist.", groupName));
        return Optional.empty();
    }
}

