/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.dataservice;

import com.blackduck.integration.blackduck.api.core.BlackDuckComponent;
import com.blackduck.integration.blackduck.api.core.BlackDuckView;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.generated.view.TagView;
import com.blackduck.integration.blackduck.api.manual.view.ProjectView;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import java.util.List;
import java.util.Optional;

public class TagService
extends DataService {
    public TagService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger) {
        super(blackDuckApiClient, apiDiscovery, logger);
    }

    public List<TagView> getAllTags(ProjectView projectView) throws IntegrationException {
        return this.blackDuckApiClient.getAllResponses(projectView.metaTagsLink());
    }

    public Optional<TagView> findMatchingTag(ProjectView projectView, String tagName) throws IntegrationException {
        return this.getAllTags(projectView).stream().filter(tagView -> tagView.getName().equals(tagName)).findFirst();
    }

    public void updateTag(TagView tag) throws IntegrationException {
        this.blackDuckApiClient.put((BlackDuckView)tag);
    }

    public TagView createTag(ProjectView projectView, TagView tag) throws IntegrationException {
        if (!projectView.hasLink("tags")) {
            throw new BlackDuckIntegrationException(String.format("The supplied projectView does not have the link (%s) to create a tag.", "tags"));
        }
        HttpUrl tagsLink = projectView.getFirstLink("tags");
        HttpUrl tagLink = this.blackDuckApiClient.post(tagsLink, (BlackDuckComponent)tag);
        return this.blackDuckApiClient.getResponse(tagLink, TagView.class);
    }
}

