/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.dataservice;

import com.blackduck.integration.blackduck.api.core.BlackDuckComponent;
import com.blackduck.integration.blackduck.api.core.response.UrlMultipleResponses;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.generated.view.UserGroupView;
import com.blackduck.integration.blackduck.api.generated.view.UserView;
import com.blackduck.integration.blackduck.api.manual.temporary.component.AssignedUserGroupRequest;
import com.blackduck.integration.blackduck.api.manual.temporary.component.AssignedUserRequest;
import com.blackduck.integration.blackduck.api.manual.temporary.response.AssignedUserGroupView;
import com.blackduck.integration.blackduck.api.manual.temporary.view.AssignedUserView;
import com.blackduck.integration.blackduck.api.manual.view.ProjectView;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.blackduck.service.dataservice.UserGroupService;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ProjectUsersService
extends DataService {
    private final UserGroupService userGroupService;

    public ProjectUsersService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger, UserGroupService userGroupService) {
        super(blackDuckApiClient, apiDiscovery, logger);
        this.userGroupService = userGroupService;
    }

    public List<AssignedUserView> getAssignedUsersToProject(ProjectView project) throws IntegrationException {
        List<AssignedUserView> assignedUsers = this.blackDuckApiClient.getAllResponses(project.metaUsersLink());
        return assignedUsers;
    }

    public List<UserView> getUsersForProject(ProjectView project) throws IntegrationException {
        this.logger.debug("Attempting to get the assigned users for Project: " + project.getName());
        List<AssignedUserView> assignedUsers = this.getAssignedUsersToProject(project);
        ArrayList<UserView> resolvedUserViews = new ArrayList<UserView>();
        for (AssignedUserView assigned : assignedUsers) {
            HttpUrl userUrl = new HttpUrl(assigned.getUser());
            UserView userView = this.blackDuckApiClient.getResponse(userUrl, UserView.class);
            if (userView == null) continue;
            resolvedUserViews.add(userView);
        }
        return resolvedUserViews;
    }

    public List<AssignedUserGroupView> getAssignedGroupsToProject(ProjectView project) throws IntegrationException {
        List<AssignedUserGroupView> assignedGroups = this.blackDuckApiClient.getAllResponses(project.metaUsergroupsLink());
        return assignedGroups;
    }

    public List<UserGroupView> getGroupsForProject(ProjectView project) throws IntegrationException {
        this.logger.debug("Attempting to get the assigned users for Project: " + project.getName());
        List<AssignedUserGroupView> assignedGroups = this.getAssignedGroupsToProject(project);
        ArrayList<UserGroupView> resolvedGroupViews = new ArrayList<UserGroupView>();
        for (AssignedUserGroupView assigned : assignedGroups) {
            HttpUrl groupUrl = new HttpUrl(assigned.getGroup());
            UserGroupView groupView = this.blackDuckApiClient.getResponse(groupUrl, UserGroupView.class);
            if (groupView == null) continue;
            resolvedGroupViews.add(groupView);
        }
        return resolvedGroupViews;
    }

    public Set<UserView> getAllActiveUsersForProject(ProjectView projectView) throws IntegrationException {
        HashSet<Object> users = new HashSet<Object>();
        List<AssignedUserGroupView> assignedGroups = this.getAssignedGroupsToProject(projectView);
        for (AssignedUserGroupView assignedUserGroupView : assignedGroups) {
            HttpUrl groupUrl;
            UserGroupView userGroupView;
            if (!assignedUserGroupView.getActive().booleanValue() || !(userGroupView = this.blackDuckApiClient.getResponse(groupUrl = new HttpUrl(assignedUserGroupView.getGroup()), UserGroupView.class)).getActive().booleanValue()) continue;
            List groupUsers = this.blackDuckApiClient.getAllResponses(userGroupView.metaUsersLink());
            users.addAll(groupUsers);
        }
        List<AssignedUserView> assignedUsers = this.getAssignedUsersToProject(projectView);
        for (AssignedUserView assignedUser : assignedUsers) {
            HttpUrl userUrl = new HttpUrl(assignedUser.getUser());
            UserView userView = this.blackDuckApiClient.getResponse(userUrl, UserView.class);
            users.add(userView);
        }
        return users.stream().filter(UserView::getActive).collect(Collectors.toSet());
    }

    public void addGroupToProject(ProjectView projectView, String groupName) throws IntegrationException {
        Optional<UserGroupView> optionalUserGroupView = this.userGroupService.getGroupByName(groupName);
        UserGroupView userGroupView = optionalUserGroupView.orElseThrow(() -> new IntegrationException(String.format("The supplied group name (%s) does not exist.", groupName)));
        HttpUrl userGroupUrl = userGroupView.getHref();
        HttpUrl createUrl = projectView.getFirstLink("usergroups");
        AssignedUserGroupRequest userGroupRequest = new AssignedUserGroupRequest();
        userGroupRequest.setGroup(userGroupUrl.string());
        this.blackDuckApiClient.post(createUrl, (BlackDuckComponent)userGroupRequest);
    }

    public void addUserToProject(ProjectView projectView, String username) throws IntegrationException {
        UrlMultipleResponses userResponses = this.apiDiscovery.metaUsersLink();
        List allUsers = this.blackDuckApiClient.getAllResponses(userResponses);
        UserView userView = null;
        for (UserView user : allUsers) {
            if (!user.getUserName().equalsIgnoreCase(username)) continue;
            userView = user;
        }
        if (null == userView) {
            throw new BlackDuckIntegrationException(String.format("The user (%s) does not exist.", username));
        }
        this.addUserToProject(projectView, userView);
    }

    public void addUserToProject(ProjectView projectView, UserView userView) throws IntegrationException {
        AssignedUserRequest assignedUserRequest = new AssignedUserRequest();
        HttpUrl userUrl = userView.getHref();
        assignedUserRequest.setUser(userUrl.string());
        HttpUrl addUserUrl = projectView.getFirstLink("users");
        this.blackDuckApiClient.post(addUserUrl, (BlackDuckComponent)assignedUserRequest);
    }
}

