/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.dataservice;

import com.blackduck.integration.blackduck.api.core.BlackDuckComponent;
import com.blackduck.integration.blackduck.api.core.BlackDuckView;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.manual.view.ProjectMappingView;
import com.blackduck.integration.blackduck.api.manual.view.ProjectView;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import java.util.List;

public class ProjectMappingService
extends DataService {
    public ProjectMappingService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger) {
        super(blackDuckApiClient, apiDiscovery, logger);
    }

    public void populateApplicationId(ProjectView projectView, String applicationId) throws IntegrationException {
        List projectMappings = this.blackDuckApiClient.getAllResponses(projectView.metaProjectMappingsLink());
        boolean canCreate = projectMappings.isEmpty();
        if (canCreate) {
            if (!projectView.hasLink("project-mappings")) {
                throw new BlackDuckIntegrationException(String.format("The supplied projectView does not have the link (%s) to create a project mapping.", "project-mappings"));
            }
            HttpUrl projectMappingsLink = projectView.getFirstLink("project-mappings");
            ProjectMappingView projectMappingView = new ProjectMappingView();
            projectMappingView.setApplicationId(applicationId);
            this.blackDuckApiClient.post(projectMappingsLink, (BlackDuckComponent)projectMappingView);
        } else {
            ProjectMappingView projectMappingView = (ProjectMappingView)projectMappings.get(0);
            projectMappingView.setApplicationId(applicationId);
            this.blackDuckApiClient.put((BlackDuckView)projectMappingView);
        }
    }

    public List<ProjectMappingView> getProjectMappings(ProjectView projectView) throws IntegrationException {
        return this.blackDuckApiClient.getAllResponses(projectView.metaProjectMappingsLink());
    }
}

