/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.dataservice;

import com.blackduck.integration.blackduck.api.core.response.UrlMultipleResponses;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionView;
import com.blackduck.integration.blackduck.api.manual.view.ProjectView;
import com.blackduck.integration.blackduck.http.BlackDuckQuery;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.blackduck.service.request.BlackDuckMultipleRequest;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class ProjectGetService
extends DataService {
    private final UrlMultipleResponses<ProjectView> projectsResponses;

    public ProjectGetService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger) {
        super(blackDuckApiClient, apiDiscovery, logger);
        this.projectsResponses = this.apiDiscovery.metaMultipleResponses(ApiDiscovery.PROJECTS_PATH);
    }

    public List<ProjectView> getAllProjectMatches(String projectName) throws IntegrationException {
        BlackDuckQuery blackDuckQuery = new BlackDuckQuery("name", projectName);
        BlackDuckRequestBuilder blackDuckRequestBuilder = new BlackDuckRequestBuilder().commonGet().addBlackDuckQuery(blackDuckQuery);
        BlackDuckMultipleRequest<ProjectView> requestMultiple = blackDuckRequestBuilder.buildBlackDuckRequest(this.projectsResponses);
        return this.blackDuckApiClient.getAllResponses(requestMultiple);
    }

    public List<ProjectView> getProjectMatches(String projectName, int limit) throws IntegrationException {
        BlackDuckQuery blackDuckQuery = new BlackDuckQuery("name", projectName);
        BlackDuckRequestBuilder blackDuckRequestBuilder = new BlackDuckRequestBuilder().commonGet().addBlackDuckQuery(blackDuckQuery);
        BlackDuckMultipleRequest<ProjectView> requestMultiple = blackDuckRequestBuilder.buildBlackDuckRequest(this.projectsResponses);
        return this.blackDuckApiClient.getSomeResponses(requestMultiple, limit);
    }

    public Optional<ProjectView> getProjectViewByProjectName(String projectName) throws IntegrationException {
        List<ProjectView> allProjectItems = this.getAllProjectMatches(projectName);
        for (ProjectView project : allProjectItems) {
            if (!projectName.equalsIgnoreCase(project.getName())) continue;
            return Optional.of(project);
        }
        return Optional.empty();
    }

    public Optional<ProjectVersionView> getProjectVersionViewByProjectVersionName(ProjectView projectView, String projectVersionName) throws IntegrationException {
        BlackDuckQuery blackDuckQuery = new BlackDuckQuery("versionName", projectVersionName);
        BlackDuckRequestBuilder blackDuckRequestBuilder = new BlackDuckRequestBuilder().commonGet().addBlackDuckQuery(blackDuckQuery);
        BlackDuckMultipleRequest requestMultiple = blackDuckRequestBuilder.buildBlackDuckRequest(projectView.metaVersionsLink());
        Predicate<ProjectVersionView> predicate = projectVersionView -> projectVersionName.equals(projectVersionView.getVersionName());
        return this.blackDuckApiClient.getSomeMatchingResponses(requestMultiple, predicate, 1).stream().findFirst();
    }
}

