/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.dataservice;

import com.blackduck.integration.bdio.model.externalid.ExternalId;
import com.blackduck.integration.blackduck.api.core.response.UrlMultipleResponses;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.generated.response.ComponentsView;
import com.blackduck.integration.blackduck.api.generated.view.ComponentMatchedFilesView;
import com.blackduck.integration.blackduck.api.generated.view.ComponentVersionView;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionComponentVersionView;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionPolicyRulesView;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionPolicyStatusView;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionView;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionVulnerableBomComponentsView;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.blackduck.service.dataservice.ComponentService;
import com.blackduck.integration.blackduck.service.model.ComponentVersionVulnerabilities;
import com.blackduck.integration.blackduck.service.model.VersionBomComponentModel;
import com.blackduck.integration.blackduck.service.request.BlackDuckResponseRequest;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.body.BodyContentConverter;
import com.blackduck.integration.rest.response.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ProjectBomService
extends DataService {
    private final ComponentService componentService;

    public ProjectBomService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger, ComponentService componentService) {
        super(blackDuckApiClient, apiDiscovery, logger);
        this.componentService = componentService;
    }

    public List<ProjectVersionComponentVersionView> getComponentsForProjectVersion(ProjectVersionView projectVersionView) throws IntegrationException {
        List<ProjectVersionComponentVersionView> projectVersionComponentVersionViews = this.blackDuckApiClient.getAllResponses(projectVersionView.metaComponentsLink());
        return projectVersionComponentVersionViews;
    }

    public List<ProjectVersionVulnerableBomComponentsView> getVulnerableComponentsForProjectVersion(ProjectVersionView projectVersionView) throws IntegrationException {
        List<ProjectVersionVulnerableBomComponentsView> vulnerableBomComponentViews = this.blackDuckApiClient.getAllResponses(projectVersionView.metaVulnerableComponentsLink());
        return vulnerableBomComponentViews;
    }

    public List<ComponentVersionVulnerabilities> getComponentVersionVulnerabilities(ProjectVersionView projectVersionView) throws IntegrationException {
        List<ProjectVersionComponentVersionView> ProjectVersionComponentViews = this.getComponentsForProjectVersion(projectVersionView);
        ArrayList<ComponentVersionView> componentVersionViews = new ArrayList<ComponentVersionView>();
        for (ProjectVersionComponentVersionView projectVersionComponentVersionView : ProjectVersionComponentViews) {
            if (!StringUtils.isNotBlank((CharSequence)projectVersionComponentVersionView.getComponentVersion())) continue;
            HttpUrl projectVersionComponentUrl = new HttpUrl(projectVersionComponentVersionView.getComponentVersion());
            ComponentVersionView componentVersionView = this.blackDuckApiClient.getResponse(projectVersionComponentUrl, ComponentVersionView.class);
            componentVersionViews.add(componentVersionView);
        }
        ArrayList<ComponentVersionVulnerabilities> componentVersionVulnerabilitiesList = new ArrayList<ComponentVersionVulnerabilities>();
        for (ComponentVersionView componentVersionView : componentVersionViews) {
            ComponentVersionVulnerabilities componentVersionVulnerabilities = this.componentService.getComponentVersionVulnerabilities(componentVersionView);
            componentVersionVulnerabilitiesList.add(componentVersionVulnerabilities);
        }
        return componentVersionVulnerabilitiesList;
    }

    public List<VersionBomComponentModel> getComponentsWithMatchedFilesForProjectVersion(ProjectVersionView version) throws IntegrationException {
        List bomComponents = this.blackDuckApiClient.getAllResponses(version.metaComponentsLink());
        ArrayList<VersionBomComponentModel> modelBomComponents = new ArrayList<VersionBomComponentModel>(bomComponents.size());
        for (ProjectVersionComponentVersionView component : bomComponents) {
            modelBomComponents.add(new VersionBomComponentModel(component, this.getMatchedFiles(component)));
        }
        return modelBomComponents;
    }

    public Optional<ProjectVersionPolicyStatusView> getPolicyStatusForVersion(ProjectVersionView version) throws IntegrationException {
        if (version.metaPolicyStatusLinkSafely().isPresent()) {
            return Optional.ofNullable((ProjectVersionPolicyStatusView)this.blackDuckApiClient.getResponse(version.metaPolicyStatusLink()));
        }
        return Optional.empty();
    }

    public Optional<List<ProjectVersionPolicyRulesView>> getActivePoliciesForVersion(ProjectVersionView version) {
        UrlMultipleResponses url = version.metaActivePolicyRulesLink();
        try {
            return Optional.ofNullable(this.blackDuckApiClient.getAllResponses(url));
        }
        catch (IntegrationException e) {
            return Optional.empty();
        }
    }

    public Optional<String> addComponentToProjectVersion(ExternalId componentExternalId, ProjectVersionView projectVersionView) throws IntegrationException {
        HttpUrl projectVersionComponentsUrl = projectVersionView.getFirstLink("components");
        Optional<ComponentsView> componentSearchResultView = this.componentService.getFirstOrEmptyResult(componentExternalId);
        String componentVersionUrl = null;
        if (componentSearchResultView.isPresent()) {
            componentVersionUrl = StringUtils.isNotBlank((CharSequence)componentSearchResultView.get().getVariant()) ? componentSearchResultView.get().getVariant() : (StringUtils.isNotBlank((CharSequence)componentSearchResultView.get().getVersion()) ? componentSearchResultView.get().getVersion() : componentSearchResultView.get().getComponent());
            this.addComponentToProjectVersion(new HttpUrl(componentVersionUrl), projectVersionComponentsUrl);
        }
        return Optional.ofNullable(componentVersionUrl);
    }

    public void addProjectVersionToProjectVersion(ProjectVersionView projectVersionViewToAdd, ProjectVersionView targetProjectVersionView) throws IntegrationException {
        HttpUrl toAddUrl = projectVersionViewToAdd.getHref();
        HttpUrl targetUrl = targetProjectVersionView.getFirstLink("components");
        this.addComponentToProjectVersion(toAddUrl, targetUrl);
    }

    public void addComponentToProjectVersion(ComponentVersionView componentVersionView, ProjectVersionView projectVersionView) throws IntegrationException {
        HttpUrl componentVersionUrl = componentVersionView.getHref();
        HttpUrl projectVersionComponentsUrl = projectVersionView.getFirstLink("components");
        this.addComponentToProjectVersion(componentVersionUrl, projectVersionComponentsUrl);
    }

    public void addComponentToProjectVersion(HttpUrl componentVersionUrl, HttpUrl projectVersionComponentsUrl) throws IntegrationException {
        BlackDuckResponseRequest request = new BlackDuckRequestBuilder().postString("{\"component\": \"" + componentVersionUrl.string() + "\"}", BodyContentConverter.DEFAULT).buildBlackDuckResponseRequest(projectVersionComponentsUrl);
        try {
            Response response = this.blackDuckApiClient.execute(request);
            if (response != null) {
                response.close();
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), (Throwable)e);
        }
    }

    private List<ComponentMatchedFilesView> getMatchedFiles(ProjectVersionComponentVersionView component) throws IntegrationException {
        List<Object> matchedFiles = new ArrayList<ComponentMatchedFilesView>(0);
        List tempMatchedFiles = this.blackDuckApiClient.getAllResponses(component.metaMatchedFilesLink());
        if (tempMatchedFiles != null && !tempMatchedFiles.isEmpty()) {
            matchedFiles = tempMatchedFiles;
        }
        return matchedFiles;
    }
}

