/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.dataservice;

import com.blackduck.integration.bdio.model.externalid.ExternalId;
import com.blackduck.integration.blackduck.api.core.BlackDuckComponent;
import com.blackduck.integration.blackduck.api.core.response.UrlMultipleResponses;
import com.blackduck.integration.blackduck.api.enumeration.PolicyRuleConditionOperatorType;
import com.blackduck.integration.blackduck.api.generated.component.PolicyRuleExpressionView;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.generated.response.ComponentsView;
import com.blackduck.integration.blackduck.api.generated.view.ComponentVersionView;
import com.blackduck.integration.blackduck.api.generated.view.PolicyRuleView;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.blackduck.service.dataservice.ComponentService;
import com.blackduck.integration.blackduck.service.model.PolicyRuleExpressionSetBuilder;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class PolicyRuleService
extends DataService {
    private final UrlMultipleResponses<PolicyRuleView> policyRulesResponses;

    public PolicyRuleService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger) {
        super(blackDuckApiClient, apiDiscovery, logger);
        this.policyRulesResponses = this.apiDiscovery.metaMultipleResponses(ApiDiscovery.POLICY_RULES_PATH);
    }

    public List<PolicyRuleView> getAllPolicyRules() throws IntegrationException {
        return this.blackDuckApiClient.getAllResponses(this.policyRulesResponses);
    }

    public Optional<PolicyRuleView> getPolicyRuleViewByName(String policyRuleName) throws IntegrationException {
        Predicate<PolicyRuleView> predicate = policyRuleView -> policyRuleName.equals(policyRuleView.getName());
        List<PolicyRuleView> allPolicyRules = this.blackDuckApiClient.getSomeMatchingResponses(this.policyRulesResponses, predicate, 1);
        for (PolicyRuleView policyRule : allPolicyRules) {
            if (!policyRuleName.equals(policyRule.getName())) continue;
            return Optional.of(policyRule);
        }
        return Optional.empty();
    }

    public HttpUrl createPolicyRule(PolicyRuleView policyRuleView) throws IntegrationException {
        return this.blackDuckApiClient.post(this.policyRulesResponses.getUrl(), (BlackDuckComponent)policyRuleView);
    }

    public HttpUrl createPolicyRuleForExternalId(ComponentService componentService, ExternalId externalId, String policyName) throws IntegrationException {
        Optional<ComponentsView> componentSearchResult = componentService.getSingleOrEmptyResult(externalId);
        if (!componentSearchResult.isPresent()) {
            throw new BlackDuckIntegrationException(String.format("The external id (%s) provided could not be found, so no policy can be created for it.", externalId.createExternalId()));
        }
        Optional<ComponentVersionView> componentVersionView = componentService.getComponentVersionView(componentSearchResult.get());
        if (!componentVersionView.isPresent()) {
            throw new BlackDuckIntegrationException(String.format("A component version could not be found for the provided external id (%s), so no policy can be created for it.", externalId.createExternalId()));
        }
        PolicyRuleExpressionSetBuilder builder = new PolicyRuleExpressionSetBuilder();
        builder.addComponentVersionCondition(PolicyRuleConditionOperatorType.EQ, componentVersionView.get());
        PolicyRuleExpressionView expressionSet = builder.createPolicyRuleExpressionView();
        PolicyRuleView policyRuleView = new PolicyRuleView();
        policyRuleView.setName(policyName);
        policyRuleView.setEnabled(Boolean.valueOf(true));
        policyRuleView.setOverridable(Boolean.valueOf(true));
        policyRuleView.setExpression(expressionSet);
        return this.createPolicyRule(policyRuleView);
    }
}

