/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.dataservice;

import com.blackduck.integration.blackduck.api.core.response.UrlMultipleResponses;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.generated.view.UserView;
import com.blackduck.integration.blackduck.api.manual.temporary.enumeration.NotificationType;
import com.blackduck.integration.blackduck.api.manual.view.NotificationUserView;
import com.blackduck.integration.blackduck.api.manual.view.NotificationView;
import com.blackduck.integration.blackduck.http.BlackDuckPageDefinition;
import com.blackduck.integration.blackduck.http.BlackDuckPageResponse;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.http.BlackDuckRequestFilter;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.blackduck.service.request.BlackDuckMultipleRequest;
import com.blackduck.integration.blackduck.service.request.NotificationEditor;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NotificationService
extends DataService {
    private final UrlMultipleResponses<NotificationView> notificationsResponses;
    private final Function<UserView, UrlMultipleResponses<NotificationUserView>> userNotificationsResponses;

    public NotificationService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger) {
        super(blackDuckApiClient, apiDiscovery, logger);
        this.notificationsResponses = this.apiDiscovery.metaMultipleResponses(ApiDiscovery.NOTIFICATIONS_PATH);
        this.userNotificationsResponses = userView -> userView.metaNotificationsLink();
    }

    public List<NotificationView> getAllNotifications(NotificationEditor notificationEditor) throws IntegrationException {
        BlackDuckRequestBuilder blackDuckRequestBuilder = this.createNotificationRequestBuilder(notificationEditor);
        BlackDuckMultipleRequest<NotificationView> requestMultiple = blackDuckRequestBuilder.buildBlackDuckRequest(this.notificationsResponses);
        List possiblyPoorlyFilteredNotifications = this.blackDuckApiClient.getAllResponses(requestMultiple);
        return this.reallyFilterNotifications(possiblyPoorlyFilteredNotifications, notificationEditor.getNotificationTypesToInclude());
    }

    public List<NotificationUserView> getAllUserNotifications(UserView userView, NotificationEditor notificationEditor) throws IntegrationException {
        BlackDuckRequestBuilder blackDuckRequestBuilder = this.createNotificationRequestBuilder(notificationEditor);
        BlackDuckMultipleRequest<NotificationUserView> requestMultiple = blackDuckRequestBuilder.buildBlackDuckRequest(this.userNotificationsResponses.apply(userView));
        List possiblyPoorlyFilteredNotifications = this.blackDuckApiClient.getAllResponses(requestMultiple);
        return this.reallyFilterNotifications(possiblyPoorlyFilteredNotifications, notificationEditor.getNotificationTypesToInclude());
    }

    public BlackDuckPageResponse<NotificationView> getPageOfNotifications(NotificationEditor notificationEditor, BlackDuckPageDefinition blackDuckPageDefinition) throws IntegrationException {
        BlackDuckRequestBuilder blackDuckRequestBuilder = this.createNotificationRequestBuilder(notificationEditor).setBlackDuckPageDefinition(blackDuckPageDefinition);
        BlackDuckMultipleRequest<NotificationView> requestMultiple = blackDuckRequestBuilder.buildBlackDuckRequest(this.notificationsResponses);
        return this.blackDuckApiClient.getPageResponse(requestMultiple);
    }

    public BlackDuckPageResponse<NotificationUserView> getPageOfUserNotifications(UserView userView, NotificationEditor notificationEditor, BlackDuckPageDefinition blackDuckPageDefinition) throws IntegrationException {
        BlackDuckRequestBuilder blackDuckRequestBuilder = this.createNotificationRequestBuilder(notificationEditor).setBlackDuckPageDefinition(blackDuckPageDefinition);
        BlackDuckMultipleRequest<NotificationUserView> requestMultiple = blackDuckRequestBuilder.buildBlackDuckRequest(this.userNotificationsResponses.apply(userView));
        return this.blackDuckApiClient.getPageResponse(requestMultiple);
    }

    public Date getLatestNotificationDate() throws IntegrationException {
        BlackDuckRequestBuilder blackDuckRequestBuilder = this.createLatestDateRequestBuilder();
        BlackDuckMultipleRequest<NotificationView> requestMultiple = blackDuckRequestBuilder.buildBlackDuckRequest(this.notificationsResponses);
        List notifications = this.blackDuckApiClient.getSomeResponses(requestMultiple, 1);
        return this.getFirstCreatedAtDate(notifications);
    }

    public Date getLatestUserNotificationDate(UserView userView) throws IntegrationException {
        BlackDuckRequestBuilder blackDuckRequestBuilder = this.createLatestDateRequestBuilder();
        BlackDuckMultipleRequest<NotificationUserView> requestMultiple = blackDuckRequestBuilder.buildBlackDuckRequest(this.userNotificationsResponses.apply(userView));
        List userNotifications = this.blackDuckApiClient.getSomeResponses(requestMultiple, 1);
        return this.getFirstCreatedAtDate(userNotifications);
    }

    private Date getFirstCreatedAtDate(List<? extends NotificationView> notifications) {
        if (notifications.size() == 1) {
            return notifications.get(0).getCreatedAt();
        }
        return new Date();
    }

    private BlackDuckRequestBuilder createLatestDateRequestBuilder() {
        return new BlackDuckRequestBuilder().commonGet().addBlackDuckFilter(this.createFilterForAllKnownTypes());
    }

    private List<String> getAllKnownNotificationTypes() {
        List<String> allKnownTypes = Stream.of(NotificationType.values()).map(Enum::name).collect(Collectors.toList());
        return allKnownTypes;
    }

    private BlackDuckRequestFilter createFilterForAllKnownTypes() {
        return this.createFilterForSpecificTypes(this.getAllKnownNotificationTypes());
    }

    private BlackDuckRequestFilter createFilterForSpecificTypes(List<String> notificationTypesToInclude) {
        return BlackDuckRequestFilter.createFilterWithMultipleValues("notificationType", notificationTypesToInclude);
    }

    private BlackDuckRequestBuilder createNotificationRequestBuilder(NotificationEditor notificationEditor) {
        return new BlackDuckRequestBuilder().commonGet().apply(notificationEditor);
    }

    private <T extends NotificationView> List<T> reallyFilterNotifications(List<T> notifications, List<String> notificationTypesToInclude) {
        return notifications.stream().filter(notification -> notificationTypesToInclude.contains(notification.getType().name())).collect(Collectors.toList());
    }
}

