/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.dataservice;

import com.blackduck.integration.bdio.model.externalid.ExternalId;
import com.blackduck.integration.blackduck.api.core.BlackDuckView;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.generated.response.ComponentsView;
import com.blackduck.integration.blackduck.api.generated.view.ComponentVersionLicenseLicensesView;
import com.blackduck.integration.blackduck.api.generated.view.ComponentVersionLicenseView;
import com.blackduck.integration.blackduck.api.generated.view.ComponentVersionView;
import com.blackduck.integration.blackduck.api.generated.view.LicenseView;
import com.blackduck.integration.blackduck.api.manual.temporary.component.VersionBomLicenseView;
import com.blackduck.integration.blackduck.http.BlackDuckQuery;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.blackduck.service.dataservice.ComponentService;
import com.blackduck.integration.blackduck.service.request.BlackDuckRequest;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.response.Response;
import java.io.IOException;
import java.util.List;
import java.util.Optional;

public class LicenseService
extends DataService {
    private final ComponentService componentDataService;

    public LicenseService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger, ComponentService componentDataService) {
        super(blackDuckApiClient, apiDiscovery, logger);
        this.componentDataService = componentDataService;
    }

    public Optional<ComponentVersionLicenseView> getComplexLicenseItemFromComponent(ExternalId externalId) throws IntegrationException {
        Optional<ComponentsView> componentSearchView = this.componentDataService.getFirstOrEmptyResult(externalId);
        if (!componentSearchView.isPresent()) {
            return Optional.empty();
        }
        HttpUrl componentVersionUrl = new HttpUrl(componentSearchView.get().getVersion());
        ComponentVersionView componentVersion = this.blackDuckApiClient.getResponse(componentVersionUrl, ComponentVersionView.class);
        return Optional.ofNullable(componentVersion.getLicense());
    }

    public LicenseView getLicenseView(VersionBomLicenseView versionBomLicenseView) throws IntegrationException {
        HttpUrl url = new HttpUrl(versionBomLicenseView.getLicense());
        return this.getLicenseView(url);
    }

    public LicenseView getLicenseView(ComponentVersionLicenseLicensesView componentVersionLicenseLicensesView) throws IntegrationException {
        HttpUrl url = new HttpUrl(componentVersionLicenseLicensesView.getLicense());
        return this.getLicenseView(url);
    }

    public LicenseView getLicenseView(HttpUrl licenseUrl) throws IntegrationException {
        if (licenseUrl == null) {
            return null;
        }
        LicenseView licenseView = this.blackDuckApiClient.getResponse(licenseUrl, LicenseView.class);
        return licenseView;
    }

    public String getLicenseText(LicenseView licenseView) throws IntegrationException {
        String string;
        block8: {
            HttpUrl licenseTextUrl = licenseView.getFirstLink("text");
            Response response = this.blackDuckApiClient.get(licenseTextUrl);
            try {
                string = response.getContentString();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IntegrationException(e.getMessage(), (Throwable)e);
                }
            }
            response.close();
        }
        return string;
    }

    public List<LicenseView> searchLicensesByName(String licenseName) throws IntegrationException {
        BlackDuckQuery nameQuery = new BlackDuckQuery("name:" + licenseName);
        BlackDuckRequest requestMultiple = new BlackDuckRequest(new BlackDuckRequestBuilder().commonGet().addBlackDuckQuery(nameQuery), this.apiDiscovery.metaLicensesLink());
        return this.blackDuckApiClient.getAllResponses(requestMultiple);
    }

    public Optional<HttpUrl> getLicenseUrlByLicenseName(String licenseName) {
        try {
            return this.blackDuckApiClient.getAllResponses(this.apiDiscovery.metaLicensesLink()).stream().filter(license -> license.getName().equals(licenseName)).findFirst().map(BlackDuckView::getHref);
        }
        catch (IntegrationException e) {
            return Optional.empty();
        }
    }
}

