/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.dataservice;

import com.blackduck.integration.blackduck.api.core.BlackDuckComponent;
import com.blackduck.integration.blackduck.api.core.BlackDuckView;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.generated.view.IssueView;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionComponentVersionView;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionIssuesView;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionView;
import com.blackduck.integration.blackduck.api.manual.temporary.component.IssueRequest;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class IssueService
extends DataService {
    public IssueService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger) {
        super(blackDuckApiClient, apiDiscovery, logger);
    }

    public List<ProjectVersionIssuesView> getIssuesForProjectVersion(ProjectVersionView projectVersionView) throws IntegrationException {
        return this.blackDuckApiClient.getAllResponses(projectVersionView.metaIssuesLink());
    }

    public Optional<IssueView> getIssueByKey(ProjectVersionView projectVersionView, String issueKey) throws IntegrationException {
        Predicate<ProjectVersionIssuesView> issueKeyEquals = issue -> issue.getIssueId().equals(issueKey);
        List<ProjectVersionIssuesView> bomComponentIssues = this.blackDuckApiClient.getSomeMatchingResponses(projectVersionView.metaIssuesLink(), issueKeyEquals, 1);
        Optional projectVersionIssuesViewOptional = bomComponentIssues.stream().findAny();
        if (projectVersionIssuesViewOptional.isPresent()) {
            return Optional.ofNullable(this.getIssueView((ProjectVersionIssuesView)projectVersionIssuesViewOptional.get()));
        }
        return Optional.empty();
    }

    public IssueView getIssueView(ProjectVersionIssuesView projectVersionIssuesView) throws IntegrationException {
        HttpUrl issueUrl = projectVersionIssuesView.getHref();
        return this.blackDuckApiClient.getResponse(issueUrl, IssueView.class);
    }

    public void createIssueForComponent(ProjectVersionComponentVersionView projectVersionComponentView, IssueRequest issueRequest) throws IntegrationException {
        HttpUrl createIssueUrl = projectVersionComponentView.getFirstLink("component-issues");
        this.blackDuckApiClient.post(createIssueUrl, (BlackDuckComponent)issueRequest);
    }

    public void updateIssue(IssueView issueView) throws IntegrationException {
        this.blackDuckApiClient.put((BlackDuckView)issueView);
    }
}

