/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.dataservice;

import com.blackduck.integration.blackduck.api.core.BlackDuckPath;
import com.blackduck.integration.blackduck.api.core.BlackDuckResponse;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.request.BlackDuckResponseRequest;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.response.Response;
import org.apache.http.entity.ContentType;

public class IacScanUploadService {
    public static final String IAC_SCAN_UPLOAD_PATH_PATTERN = "/api/internal/scans/%s/iac-issues";
    public static final String HEADER_CONTENT_TYPE = "Content-type";
    public static final String CONTENT_TYPE = "application/vnd.blackducksoftware.scan-6+json";
    private final BlackDuckApiClient blackDuckApiClient;
    private final ApiDiscovery apiDiscovery;

    public IacScanUploadService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery) {
        this.blackDuckApiClient = blackDuckApiClient;
        this.apiDiscovery = apiDiscovery;
    }

    public Response uploadIacScanResults(String resultsFileContent, String scanId) throws IntegrationException {
        HttpUrl url = this.apiDiscovery.metaSingleResponse(this.getUploadEndpoint(scanId)).getUrl();
        BlackDuckResponseRequest request = new BlackDuckRequestBuilder().postString(resultsFileContent, ContentType.create((String)CONTENT_TYPE)).addHeader(HEADER_CONTENT_TYPE, CONTENT_TYPE).buildBlackDuckResponseRequest(url);
        return this.blackDuckApiClient.execute(request);
    }

    private BlackDuckPath<BlackDuckResponse> getUploadEndpoint(String scanId) {
        return new BlackDuckPath(String.format(IAC_SCAN_UPLOAD_PATH_PATTERN, scanId), BlackDuckResponse.class, false);
    }
}

