/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.dataservice;

import com.blackduck.integration.blackduck.api.core.response.UrlSingleResponse;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.generated.response.CurrentVersionView;
import com.blackduck.integration.blackduck.api.generated.view.RegistrationView;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.blackduck.service.model.BlackDuckServerData;
import com.blackduck.integration.blackduck.service.request.BlackDuckSingleRequest;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;

public class BlackDuckRegistrationService
extends DataService {
    private final UrlSingleResponse<RegistrationView> registrationResponse;
    private final UrlSingleResponse<CurrentVersionView> currentVersionResponse;
    private final HttpUrl blackDuckUrl;

    public BlackDuckRegistrationService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger, HttpUrl blackDuckUrl) {
        super(blackDuckApiClient, apiDiscovery, logger);
        this.registrationResponse = this.apiDiscovery.metaRegistrationLink();
        this.currentVersionResponse = this.apiDiscovery.metaCurrentVersionLink();
        this.blackDuckUrl = blackDuckUrl;
    }

    public String getRegistrationId() throws IntegrationException {
        BlackDuckRequestBuilder blackDuckRequestBuilder = new BlackDuckRequestBuilder().commonGet().acceptMimeType("application/vnd.blackducksoftware.status-4+json");
        BlackDuckSingleRequest<RegistrationView> requestSingle = blackDuckRequestBuilder.buildBlackDuckRequest(this.registrationResponse);
        RegistrationView registrationView = (RegistrationView)this.blackDuckApiClient.getResponse(requestSingle);
        return registrationView.getRegistrationId();
    }

    public BlackDuckServerData getBlackDuckServerData() throws IntegrationException {
        CurrentVersionView currentVersionView = this.blackDuckApiClient.getResponse(this.currentVersionResponse);
        String registrationId = null;
        try {
            registrationId = this.getRegistrationId();
        }
        catch (IntegrationException integrationException) {
            // empty catch block
        }
        return new BlackDuckServerData(this.blackDuckUrl, currentVersionView.getVersion(), registrationId);
    }

    public BlackDuckServerData getBlackDuckServerData(boolean isAdminOperationAllowed) throws IntegrationException {
        if (isAdminOperationAllowed) {
            return this.getBlackDuckServerData();
        }
        CurrentVersionView currentVersionView = this.blackDuckApiClient.getResponse(this.currentVersionResponse);
        return new BlackDuckServerData(this.blackDuckUrl, currentVersionView.getVersion(), null);
    }
}

