/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service;

import com.blackduck.integration.blackduck.api.core.BlackDuckPath;
import com.blackduck.integration.blackduck.api.core.BlackDuckResponse;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.bdio2.Bdio2FileUploadService;
import com.blackduck.integration.blackduck.bdio2.Bdio2RetryAwareStreamUploader;
import com.blackduck.integration.blackduck.bdio2.Bdio2StreamUploader;
import com.blackduck.integration.blackduck.bdio2.util.Bdio2ContentExtractor;
import com.blackduck.integration.blackduck.codelocation.CodeLocationCreationService;
import com.blackduck.integration.blackduck.codelocation.CodeLocationWaiter;
import com.blackduck.integration.blackduck.codelocation.bdio2legacy.Bdio2UploadService;
import com.blackduck.integration.blackduck.codelocation.bdio2legacy.UploadBdio2BatchRunner;
import com.blackduck.integration.blackduck.codelocation.bdiolegacy.BdioUploadService;
import com.blackduck.integration.blackduck.codelocation.bdiolegacy.UploadBatchRunner;
import com.blackduck.integration.blackduck.codelocation.binaryscanner.BinaryScanBatchRunner;
import com.blackduck.integration.blackduck.codelocation.binaryscanner.BinaryScanUploadService;
import com.blackduck.integration.blackduck.codelocation.intelligentpersistence.IntelligentPersistenceBatchRunner;
import com.blackduck.integration.blackduck.codelocation.intelligentpersistence.IntelligentPersistenceService;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.ScanBatchRunner;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.SignatureScannerService;
import com.blackduck.integration.blackduck.http.client.BlackDuckHttpClient;
import com.blackduck.integration.blackduck.http.transform.BlackDuckJsonTransformer;
import com.blackduck.integration.blackduck.http.transform.BlackDuckResponseTransformer;
import com.blackduck.integration.blackduck.http.transform.BlackDuckResponsesTransformer;
import com.blackduck.integration.blackduck.http.transform.adapters.OffsetDateTimeTypeAdapter;
import com.blackduck.integration.blackduck.http.transform.subclass.BlackDuckResponseResolver;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.dataservice.BlackDuckRegistrationService;
import com.blackduck.integration.blackduck.service.dataservice.BlackDuckScanReadinessService;
import com.blackduck.integration.blackduck.service.dataservice.CodeLocationService;
import com.blackduck.integration.blackduck.service.dataservice.ComponentService;
import com.blackduck.integration.blackduck.service.dataservice.IacScanUploadService;
import com.blackduck.integration.blackduck.service.dataservice.IssueService;
import com.blackduck.integration.blackduck.service.dataservice.LicenseService;
import com.blackduck.integration.blackduck.service.dataservice.NotificationService;
import com.blackduck.integration.blackduck.service.dataservice.PolicyRuleService;
import com.blackduck.integration.blackduck.service.dataservice.ProjectBomService;
import com.blackduck.integration.blackduck.service.dataservice.ProjectGetService;
import com.blackduck.integration.blackduck.service.dataservice.ProjectMappingService;
import com.blackduck.integration.blackduck.service.dataservice.ProjectService;
import com.blackduck.integration.blackduck.service.dataservice.ProjectUsersService;
import com.blackduck.integration.blackduck.service.dataservice.RoleService;
import com.blackduck.integration.blackduck.service.dataservice.TagService;
import com.blackduck.integration.blackduck.service.dataservice.UserGroupService;
import com.blackduck.integration.blackduck.service.dataservice.UserRoleService;
import com.blackduck.integration.blackduck.service.dataservice.UserService;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.util.IntEnvironmentVariables;
import com.blackduck.integration.util.IntegrationEscapeUtil;
import com.blackduck.integration.util.NoThreadExecutorService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class BlackDuckServicesFactory {
    public static final ExecutorService NO_THREAD_EXECUTOR_SERVICE = new NoThreadExecutorService();
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final ExecutorService executorService;
    private final IntLogger logger;
    private final BlackDuckHttpClient blackDuckHttpClient;
    private final Gson gson;
    private final ObjectMapper objectMapper;
    private final BlackDuckResponseResolver blackDuckResponseResolver;
    private final BlackDuckJsonTransformer blackDuckJsonTransformer;
    private final BlackDuckResponseTransformer blackDuckResponseTransformer;
    private final BlackDuckResponsesTransformer blackDuckResponsesTransformer;
    private final ApiDiscovery apiDiscovery;
    private final BlackDuckApiClient blackDuckApiClient;

    public static Gson createDefaultGson() {
        return BlackDuckServicesFactory.createDefaultGsonBuilder().create();
    }

    public static ObjectMapper createDefaultObjectMapper() {
        return new ObjectMapper();
    }

    public static GsonBuilder createDefaultGsonBuilder() {
        return new GsonBuilder().setLenient().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeTypeAdapter());
    }

    public BlackDuckServicesFactory(IntEnvironmentVariables intEnvironmentVariables, ExecutorService executorService, IntLogger logger, BlackDuckHttpClient blackDuckHttpClient) {
        this(intEnvironmentVariables, executorService, logger, blackDuckHttpClient, BlackDuckServicesFactory.createDefaultGson(), BlackDuckServicesFactory.createDefaultObjectMapper());
    }

    public BlackDuckServicesFactory(IntEnvironmentVariables intEnvironmentVariables, ExecutorService executorService, IntLogger logger, BlackDuckHttpClient blackDuckHttpClient, Gson gson, ObjectMapper objectMapper) {
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.executorService = executorService;
        this.logger = logger;
        this.blackDuckHttpClient = blackDuckHttpClient;
        this.gson = gson;
        this.objectMapper = objectMapper;
        this.blackDuckResponseResolver = new BlackDuckResponseResolver(gson);
        this.blackDuckJsonTransformer = new BlackDuckJsonTransformer(gson, objectMapper, this.blackDuckResponseResolver, logger);
        this.blackDuckResponseTransformer = new BlackDuckResponseTransformer(blackDuckHttpClient, this.blackDuckJsonTransformer);
        this.blackDuckResponsesTransformer = new BlackDuckResponsesTransformer(blackDuckHttpClient, this.blackDuckJsonTransformer);
        this.apiDiscovery = new ApiDiscovery(blackDuckHttpClient.getBlackDuckUrl());
        this.blackDuckApiClient = new BlackDuckApiClient(blackDuckHttpClient, this.blackDuckJsonTransformer, this.blackDuckResponseTransformer, this.blackDuckResponsesTransformer);
    }

    public BdioUploadService createBdioUploadService() {
        return new BdioUploadService(this.blackDuckApiClient, this.apiDiscovery, this.logger, new UploadBatchRunner(this.logger, this.blackDuckApiClient, this.apiDiscovery, this.executorService), this.createCodeLocationCreationService());
    }

    public Bdio2UploadService createBdio2UploadService() {
        return new Bdio2UploadService(this.blackDuckApiClient, this.apiDiscovery, this.logger, new UploadBdio2BatchRunner(this.logger, this.blackDuckApiClient, this.apiDiscovery, this.executorService), this.createCodeLocationCreationService());
    }

    public Bdio2FileUploadService createBdio2FileUploadService() {
        Bdio2StreamUploader bdio2Uploader = new Bdio2StreamUploader(this.blackDuckApiClient, this.apiDiscovery, this.logger, (BlackDuckPath<BlackDuckResponse>)ApiDiscovery.INTELLIGENT_PERSISTENCE_SCANS_PATH, "application/vnd.blackducksoftware.intelligent-persistence-scan-2-ld-2+json");
        Bdio2RetryAwareStreamUploader bdio2RetryAwareStreamUploader = new Bdio2RetryAwareStreamUploader(bdio2Uploader);
        return new Bdio2FileUploadService(this.blackDuckApiClient, this.apiDiscovery, this.logger, new Bdio2ContentExtractor(), bdio2RetryAwareStreamUploader);
    }

    public SignatureScannerService createSignatureScannerService(File signatureScannerInstallDirectory) {
        ScanBatchRunner scanBatchRunner = ScanBatchRunner.createDefault(this.logger, this.blackDuckHttpClient, this.createBlackDuckRegistrationService(), this.intEnvironmentVariables, this.executorService, signatureScannerInstallDirectory);
        return this.createSignatureScannerService(scanBatchRunner);
    }

    public SignatureScannerService createSignatureScannerService(ScanBatchRunner scanBatchRunner) {
        return new SignatureScannerService(this.blackDuckApiClient, this.apiDiscovery, this.logger, scanBatchRunner, this.createCodeLocationCreationService());
    }

    public BinaryScanUploadService createBinaryScanUploadService() {
        return new BinaryScanUploadService(this.blackDuckApiClient, this.apiDiscovery, this.logger, new BinaryScanBatchRunner(this.logger, this.blackDuckApiClient, this.apiDiscovery, this.executorService), this.createCodeLocationCreationService());
    }

    public CodeLocationCreationService createCodeLocationCreationService() {
        ProjectService projectService = this.createProjectService();
        NotificationService notificationService = this.createNotificationService();
        UserService userService = this.createUserService();
        CodeLocationWaiter codeLocationWaiter = new CodeLocationWaiter(this.logger, this.blackDuckApiClient, projectService, notificationService);
        return new CodeLocationCreationService(this.blackDuckApiClient, this.apiDiscovery, this.logger, codeLocationWaiter, notificationService, userService);
    }

    public CodeLocationService createCodeLocationService() {
        return new CodeLocationService(this.blackDuckApiClient, this.apiDiscovery, this.logger);
    }

    public ComponentService createComponentService() {
        return new ComponentService(this.blackDuckApiClient, this.apiDiscovery, this.logger);
    }

    public BlackDuckRegistrationService createBlackDuckRegistrationService() {
        return new BlackDuckRegistrationService(this.blackDuckApiClient, this.apiDiscovery, this.logger, this.blackDuckHttpClient.getBlackDuckUrl());
    }

    public IssueService createIssueService() {
        return new IssueService(this.blackDuckApiClient, this.apiDiscovery, this.logger);
    }

    public LicenseService createLicenseService() {
        return new LicenseService(this.blackDuckApiClient, this.apiDiscovery, this.logger, this.createComponentService());
    }

    public NotificationService createNotificationService() {
        return new NotificationService(this.blackDuckApiClient, this.apiDiscovery, this.logger);
    }

    public PolicyRuleService createPolicyRuleService() {
        return new PolicyRuleService(this.blackDuckApiClient, this.apiDiscovery, this.logger);
    }

    public ProjectService createProjectService() {
        ProjectGetService projectGetService = new ProjectGetService(this.blackDuckApiClient, this.apiDiscovery, this.logger);
        return new ProjectService(this.blackDuckApiClient, this.apiDiscovery, this.logger, projectGetService);
    }

    public ProjectBomService createProjectBomService() {
        return new ProjectBomService(this.blackDuckApiClient, this.apiDiscovery, this.logger, this.createComponentService());
    }

    public ProjectUsersService createProjectUsersService() {
        UserGroupService userGroupService = this.createUserGroupService();
        return new ProjectUsersService(this.blackDuckApiClient, this.apiDiscovery, this.logger, userGroupService);
    }

    public BlackDuckScanReadinessService createScanReadinessService() {
        return new BlackDuckScanReadinessService(this.blackDuckApiClient, this.apiDiscovery, this.logger);
    }

    public UserService createUserService() {
        return new UserService(this.blackDuckApiClient, this.apiDiscovery, this.logger);
    }

    public RoleService createRoleService() {
        return new RoleService(this.blackDuckApiClient, this.apiDiscovery, this.logger);
    }

    public UserRoleService createUserRoleService() {
        return new UserRoleService(this.blackDuckApiClient, this.apiDiscovery, this.logger);
    }

    public UserGroupService createUserGroupService() {
        return new UserGroupService(this.blackDuckApiClient, this.apiDiscovery, this.logger);
    }

    public ProjectMappingService createProjectMappingService() {
        return new ProjectMappingService(this.blackDuckApiClient, this.apiDiscovery, this.logger);
    }

    public TagService createTagService() {
        return new TagService(this.blackDuckApiClient, this.apiDiscovery, this.logger);
    }

    public IntelligentPersistenceService createIntelligentPersistenceService() {
        IntelligentPersistenceBatchRunner batchRunner = new IntelligentPersistenceBatchRunner(this.logger, this.executorService, this.createBdio2FileUploadService());
        return new IntelligentPersistenceService(this.blackDuckApiClient, this.apiDiscovery, this.logger, batchRunner, this.createCodeLocationCreationService());
    }

    public IacScanUploadService createIacScanUploadService() {
        return new IacScanUploadService(this.blackDuckApiClient, this.apiDiscovery);
    }

    public IntegrationEscapeUtil createIntegrationEscapeUtil() {
        return new IntegrationEscapeUtil();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public IntLogger getLogger() {
        return this.logger;
    }

    public BlackDuckHttpClient getBlackDuckHttpClient() {
        return this.blackDuckHttpClient;
    }

    public Gson getGson() {
        return this.gson;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public IntEnvironmentVariables getEnvironmentVariables() {
        return this.intEnvironmentVariables;
    }

    public BlackDuckResponseResolver getBlackDuckResponseResolver() {
        return this.blackDuckResponseResolver;
    }

    public BlackDuckJsonTransformer getBlackDuckJsonTransformer() {
        return this.blackDuckJsonTransformer;
    }

    public BlackDuckResponseTransformer getBlackDuckResponseTransformer() {
        return this.blackDuckResponseTransformer;
    }

    public BlackDuckResponsesTransformer getBlackDuckResponsesTransformer() {
        return this.blackDuckResponsesTransformer;
    }

    public ApiDiscovery getApiDiscovery() {
        return this.apiDiscovery;
    }

    public BlackDuckApiClient getBlackDuckApiClient() {
        return this.blackDuckApiClient;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }
}

