/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service;

import com.blackduck.integration.blackduck.api.core.BlackDuckComponent;
import com.blackduck.integration.blackduck.api.core.BlackDuckPath;
import com.blackduck.integration.blackduck.api.core.BlackDuckResponse;
import com.blackduck.integration.blackduck.api.core.BlackDuckView;
import com.blackduck.integration.blackduck.api.core.response.UrlMultipleResponses;
import com.blackduck.integration.blackduck.api.core.response.UrlSingleResponse;
import com.blackduck.integration.blackduck.api.generated.discovery.BlackDuckMediaTypeDiscovery;
import com.blackduck.integration.blackduck.http.BlackDuckPageResponse;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.http.client.BlackDuckHttpClient;
import com.blackduck.integration.blackduck.http.transform.BlackDuckJsonTransformer;
import com.blackduck.integration.blackduck.http.transform.BlackDuckResponseTransformer;
import com.blackduck.integration.blackduck.http.transform.BlackDuckResponsesTransformer;
import com.blackduck.integration.blackduck.service.request.BlackDuckRequest;
import com.blackduck.integration.blackduck.service.request.BlackDuckResponseRequest;
import com.blackduck.integration.blackduck.version.BlackDuckVersion;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.rest.HttpMethod;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.body.BodyContentConverter;
import com.blackduck.integration.rest.response.Response;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class BlackDuckApiClient {
    public static final BlackDuckPath<BlackDuckResponse> SCAN_DATA_PATH = new BlackDuckPath("/api/scan/data/", BlackDuckResponse.class, false);
    private final BlackDuckHttpClient blackDuckHttpClient;
    private final BlackDuckJsonTransformer blackDuckJsonTransformer;
    private final BlackDuckResponseTransformer blackDuckResponseTransformer;
    private final BlackDuckResponsesTransformer blackDuckResponsesTransformer;
    private BlackDuckVersion blackDuckVersion;
    private BlackDuckMediaTypeDiscovery blackDuckMediaTypeDiscovery;

    public BlackDuckApiClient(BlackDuckHttpClient blackDuckHttpClient, BlackDuckJsonTransformer blackDuckJsonTransformer, BlackDuckResponseTransformer blackDuckResponseTransformer, BlackDuckResponsesTransformer blackDuckResponsesTransformer) {
        this.blackDuckHttpClient = blackDuckHttpClient;
        this.blackDuckJsonTransformer = blackDuckJsonTransformer;
        this.blackDuckResponseTransformer = blackDuckResponseTransformer;
        this.blackDuckResponsesTransformer = blackDuckResponsesTransformer;
        this.blackDuckVersion = null;
        this.blackDuckMediaTypeDiscovery = new BlackDuckMediaTypeDiscovery();
    }

    public <T extends BlackDuckResponse> List<T> getAllResponses(UrlMultipleResponses<T> urlMultipleResponses) throws IntegrationException {
        BlackDuckRequest requestMultiple = new BlackDuckRequest(new BlackDuckRequestBuilder().commonGet(), urlMultipleResponses);
        return this.getAllResponses(requestMultiple);
    }

    public <T extends BlackDuckResponse> List<T> getAllResponses(BlackDuckRequest<T, UrlMultipleResponses<T>> requestMultiple) throws IntegrationException {
        return this.blackDuckResponsesTransformer.getAllResponses(requestMultiple).getItems();
    }

    public <T extends BlackDuckResponse> List<T> getSomeMatchingResponses(UrlMultipleResponses<T> urlMultipleResponses, Predicate<T> predicate, int totalLimit) throws IntegrationException {
        BlackDuckRequestBuilder blackDuckRequestBuilder = new BlackDuckRequestBuilder().commonGet();
        BlackDuckRequest requestMultiple = new BlackDuckRequest(blackDuckRequestBuilder, urlMultipleResponses);
        return this.getSomeMatchingResponses(requestMultiple, predicate, totalLimit);
    }

    public <T extends BlackDuckResponse> List<T> getSomeMatchingResponses(BlackDuckRequest<T, UrlMultipleResponses<T>> requestMultiple, Predicate<T> predicate, int totalLimit) throws IntegrationException {
        return this.blackDuckResponsesTransformer.getSomeMatchingResponses(requestMultiple, predicate, totalLimit).getItems();
    }

    public <T extends BlackDuckResponse> List<T> getSomeResponses(UrlMultipleResponses<T> urlMultipleResponses, int totalLimit) throws IntegrationException {
        BlackDuckRequest requestMultiple = new BlackDuckRequest(new BlackDuckRequestBuilder().commonGet(), urlMultipleResponses);
        return this.getSomeResponses(requestMultiple, totalLimit);
    }

    public <T extends BlackDuckResponse> List<T> getSomeResponses(BlackDuckRequest<T, UrlMultipleResponses<T>> requestMultiple, int totalLimit) throws IntegrationException {
        return this.blackDuckResponsesTransformer.getSomeResponses(requestMultiple, totalLimit).getItems();
    }

    public <T extends BlackDuckResponse> BlackDuckPageResponse<T> getPageResponse(BlackDuckRequest<T, UrlMultipleResponses<T>> requestMultiple) throws IntegrationException {
        return this.blackDuckResponsesTransformer.getOnePageOfResponses(requestMultiple);
    }

    public <T extends BlackDuckResponse> T getResponse(HttpUrl url, Class<T> responseClass) throws IntegrationException {
        return this.getResponse(new UrlSingleResponse(url, responseClass));
    }

    public <T extends BlackDuckResponse> T getResponse(UrlSingleResponse<T> urlSingleResponse) throws IntegrationException {
        BlackDuckRequest requestSingle = new BlackDuckRequest(new BlackDuckRequestBuilder().commonGet(), urlSingleResponse);
        return this.getResponse(requestSingle);
    }

    public <T extends BlackDuckResponse> T getResponse(BlackDuckRequest<T, UrlSingleResponse<T>> requestSingle) throws IntegrationException {
        return this.blackDuckResponseTransformer.getResponse(requestSingle);
    }

    public HttpUrl post(HttpUrl url, BlackDuckComponent blackDuckComponent) throws IntegrationException {
        BlackDuckResponseRequest request = new BlackDuckRequestBuilder().postObject(blackDuckComponent, BodyContentConverter.DEFAULT).buildBlackDuckResponseRequest(url);
        return this.executePostRequestAndRetrieveURL(request);
    }

    public void delete(BlackDuckView blackDuckView) throws IntegrationException {
        HttpUrl url = blackDuckView.getHref();
        this.delete(url);
    }

    public void delete(HttpUrl url) throws IntegrationException {
        BlackDuckResponseRequest request = new BlackDuckRequestBuilder().method(HttpMethod.DELETE).buildBlackDuckResponseRequest(url);
        try {
            Response response = this.execute(request);
            if (response != null) {
                response.close();
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), (Throwable)e);
        }
    }

    public void put(BlackDuckView blackDuckView) throws IntegrationException {
        HttpUrl url = blackDuckView.getHref();
        String mediaType = this.blackDuckMediaTypeDiscovery.determineMediaType(url);
        String json = this.blackDuckJsonTransformer.producePatchedJson((BlackDuckResponse)blackDuckView);
        BlackDuckResponseRequest request = new BlackDuckRequestBuilder().putString(json, BodyContentConverter.DEFAULT).addHeader("Content-Type", mediaType).buildBlackDuckResponseRequest(url);
        try {
            Response response = this.execute(request);
            if (response != null) {
                response.close();
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), (Throwable)e);
        }
    }

    public Response get(HttpUrl url) throws IntegrationException {
        BlackDuckResponseRequest request = new BlackDuckRequestBuilder().buildBlackDuckResponseRequest(url);
        return this.execute(request);
    }

    public Response execute(BlackDuckResponseRequest request) throws IntegrationException {
        Response response = this.blackDuckHttpClient.execute(request);
        this.blackDuckHttpClient.throwExceptionForError(response);
        return response;
    }

    public Response executeAndRetrieveResponse(BlackDuckResponseRequest request) throws IntegrationException {
        return this.blackDuckHttpClient.execute(request);
    }

    public HttpUrl executePostRequestAndRetrieveURL(BlackDuckResponseRequest request) throws IntegrationException {
        HttpUrl httpUrl;
        block8: {
            Response response = this.execute(request);
            try {
                httpUrl = new HttpUrl(response.getHeaderValue("location"));
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IntegrationException(e.getMessage(), (Throwable)e);
                }
            }
            response.close();
        }
        return httpUrl;
    }

    public Optional<BlackDuckVersion> getBlackDuckVersion() {
        return Optional.ofNullable(this.blackDuckVersion);
    }

    public void setBlackDuckVersion(BlackDuckVersion blackDuckVersion) {
        this.blackDuckVersion = blackDuckVersion;
    }

    private BlackDuckRequestBuilder createCommonGetRequestBuilder(HttpUrl url) {
        return new BlackDuckRequestBuilder().url(url);
    }
}

