/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.phonehome;

import com.blackduck.integration.blackduck.http.client.BlackDuckHttpClient;
import com.blackduck.integration.blackduck.service.BlackDuckServicesFactory;
import com.blackduck.integration.blackduck.service.dataservice.BlackDuckRegistrationService;
import com.blackduck.integration.blackduck.service.model.BlackDuckServerData;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.phonehome.PhoneHomeClient;
import com.blackduck.integration.phonehome.PhoneHomeResponse;
import com.blackduck.integration.phonehome.PhoneHomeService;
import com.blackduck.integration.phonehome.request.PhoneHomeRequestBody;
import com.blackduck.integration.phonehome.request.PhoneHomeRequestBodyBuilder;
import com.blackduck.integration.util.IntEnvironmentVariables;
import com.blackduck.integration.util.NoThreadExecutorService;
import com.google.gson.Gson;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.http.impl.client.HttpClientBuilder;

public class BlackDuckPhoneHomeHelper {
    private final IntLogger logger;
    private final PhoneHomeService phoneHomeService;
    private final BlackDuckRegistrationService blackDuckRegistrationService;
    private final IntEnvironmentVariables intEnvironmentVariables;

    public static BlackDuckPhoneHomeHelper createPhoneHomeHelper(BlackDuckServicesFactory blackDuckServicesFactory, String apiSecret, String measurementId) {
        return BlackDuckPhoneHomeHelper.createAsynchronousPhoneHomeHelper(blackDuckServicesFactory, apiSecret, measurementId, (ExecutorService)new NoThreadExecutorService());
    }

    public static BlackDuckPhoneHomeHelper createAsynchronousPhoneHomeHelper(BlackDuckServicesFactory blackDuckServicesFactory, String apiSecret, String measurementId, ExecutorService executorService) {
        BlackDuckRegistrationService blackDuckRegistrationService = blackDuckServicesFactory.createBlackDuckRegistrationService();
        IntLogger intLogger = blackDuckServicesFactory.getLogger();
        IntEnvironmentVariables intEnvironmentVariables = blackDuckServicesFactory.getEnvironmentVariables();
        BlackDuckHttpClient blackDuckHttpClient = blackDuckServicesFactory.getBlackDuckHttpClient();
        HttpClientBuilder httpClientBuilder = blackDuckHttpClient.getHttpClientBuilder();
        Gson gson = blackDuckServicesFactory.getGson();
        PhoneHomeClient phoneHomeClient = BlackDuckPhoneHomeHelper.createPhoneHomeClient(intLogger, httpClientBuilder, gson, apiSecret, measurementId);
        PhoneHomeService phoneHomeService = PhoneHomeService.createAsynchronousPhoneHomeService((IntLogger)intLogger, (PhoneHomeClient)phoneHomeClient, (ExecutorService)executorService);
        return new BlackDuckPhoneHomeHelper(intLogger, phoneHomeService, blackDuckRegistrationService, intEnvironmentVariables);
    }

    public static PhoneHomeClient createPhoneHomeClient(IntLogger intLogger, HttpClientBuilder httpClientBuilder, Gson gson, String apiSecret, String measurementId) {
        return new PhoneHomeClient(intLogger, httpClientBuilder, gson, apiSecret, measurementId);
    }

    public BlackDuckPhoneHomeHelper(IntLogger logger, PhoneHomeService phoneHomeService, BlackDuckRegistrationService blackDuckRegistrationService, IntEnvironmentVariables intEnvironmentVariables) {
        this.logger = logger;
        this.phoneHomeService = phoneHomeService;
        this.blackDuckRegistrationService = blackDuckRegistrationService;
        this.intEnvironmentVariables = intEnvironmentVariables;
    }

    public PhoneHomeResponse handlePhoneHome(String integrationRepoName, String integrationVersion) {
        return this.handlePhoneHome(integrationRepoName, integrationVersion, Collections.emptyMap(), new String[0]);
    }

    public PhoneHomeResponse handlePhoneHome(String integrationRepoName, String integrationVersion, Map<String, String> metaData, String ... artifactModules) {
        return this.handlePhoneHome(integrationRepoName, integrationVersion, metaData, true, artifactModules);
    }

    public PhoneHomeResponse handlePhoneHome(String integrationRepoName, String integrationVersion, Map<String, String> metaData, boolean isAdminOperationAllowed, String ... artifactModules) {
        try {
            PhoneHomeRequestBody phoneHomeRequestBody = this.createPhoneHomeRequestBody(integrationRepoName, integrationVersion, metaData, isAdminOperationAllowed, artifactModules);
            return this.phoneHomeService.phoneHome(phoneHomeRequestBody, this.getEnvironmentVariables());
        }
        catch (Exception e) {
            this.logger.debug("Problem phoning home: " + e.getMessage(), (Throwable)e);
            return PhoneHomeResponse.createResponse((Boolean)Boolean.FALSE);
        }
    }

    private PhoneHomeRequestBody createPhoneHomeRequestBody(String integrationRepoName, String integrationVersion, Map<String, String> metaData, String ... artifactModules) {
        return this.createPhoneHomeRequestBody(integrationRepoName, integrationVersion, metaData, true, artifactModules);
    }

    private PhoneHomeRequestBody createPhoneHomeRequestBody(String integrationRepoName, String integrationVersion, Map<String, String> metaData, boolean isAdminOperationAllowed, String ... artifactModules) {
        String registrationKey = "<unknown>";
        String blackDuckUrl = "<unknown>";
        String blackDuckVersion = "<unknown>";
        try {
            BlackDuckServerData blackDuckServerData = this.blackDuckRegistrationService.getBlackDuckServerData(isAdminOperationAllowed);
            registrationKey = blackDuckServerData.getRegistrationKey().orElse("<unknown>");
            blackDuckUrl = blackDuckServerData.getUrl().string();
            blackDuckVersion = blackDuckServerData.getVersion();
        }
        catch (IntegrationException e) {
            this.logger.warn("Could not gather all Black Duck data: " + e.getMessage());
        }
        PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder = PhoneHomeRequestBodyBuilder.createForBlackDuck((String)integrationRepoName, (String)registrationKey, (String)blackDuckUrl, (String)integrationVersion, (String)blackDuckVersion);
        phoneHomeRequestBodyBuilder.addArtifactModules(artifactModules);
        boolean metaDataSuccess = phoneHomeRequestBodyBuilder.addAllToMetaData(metaData);
        if (!metaDataSuccess) {
            this.logger.debug("The metadata provided to phone-home exceeded its size limit. At least some metadata will be missing.");
        }
        return phoneHomeRequestBodyBuilder.build();
    }

    private Map<String, String> getEnvironmentVariables() {
        if (this.intEnvironmentVariables != null) {
            return this.intEnvironmentVariables.getVariables();
        }
        return Collections.emptyMap();
    }
}

