/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.http.transform.subclass;

import com.blackduck.integration.blackduck.api.core.BlackDuckResponse;
import com.blackduck.integration.blackduck.api.manual.view.NotificationUserView;
import com.blackduck.integration.blackduck.api.manual.view.NotificationView;
import com.blackduck.integration.blackduck.http.transform.subclass.BlackDuckResponseSubclassResolver;
import com.blackduck.integration.blackduck.http.transform.subclass.NotificationUserViewSubclassResolver;
import com.blackduck.integration.blackduck.http.transform.subclass.NotificationViewSubclassResolver;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.Map;

public class BlackDuckResponseResolver {
    private final Gson gson;
    private final Map<Class<? extends BlackDuckResponse>, BlackDuckResponseSubclassResolver<? extends BlackDuckResponse>> subclassResolvers = new HashMap<Class<? extends BlackDuckResponse>, BlackDuckResponseSubclassResolver<? extends BlackDuckResponse>>();

    public BlackDuckResponseResolver(Gson gson) {
        this.gson = gson;
        this.addSubclassResolver(NotificationView.class, new NotificationViewSubclassResolver(gson));
        this.addSubclassResolver(NotificationUserView.class, new NotificationUserViewSubclassResolver(gson));
    }

    public <T extends BlackDuckResponse> T resolve(String json, Class<T> clazz) {
        return this.resolve((JsonElement)this.gson.fromJson(json, JsonElement.class), clazz);
    }

    public <T extends BlackDuckResponse> T resolve(JsonElement jsonElement, Class<T> clazz) {
        if (this.subclassResolvers.containsKey(clazz)) {
            BlackDuckResponseSubclassResolver<? extends BlackDuckResponse> subclassResolver = this.subclassResolvers.get(clazz);
            Class<BlackDuckResponse> subclass = subclassResolver.resolveSubclass(jsonElement);
            return (T)((BlackDuckResponse)this.gson.fromJson(jsonElement, subclass));
        }
        return (T)((BlackDuckResponse)this.gson.fromJson(jsonElement, clazz));
    }

    private <T extends BlackDuckResponse> void addSubclassResolver(Class<T> clazz, BlackDuckResponseSubclassResolver<T> resolver) {
        this.subclassResolvers.put(clazz, resolver);
    }
}

