/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.http.transform;

import com.blackduck.integration.blackduck.api.core.BlackDuckResponse;
import com.blackduck.integration.blackduck.api.core.response.UrlMultipleResponses;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.blackduck.http.BlackDuckPageResponse;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.http.client.BlackDuckHttpClient;
import com.blackduck.integration.blackduck.http.transform.BlackDuckJsonTransformer;
import com.blackduck.integration.blackduck.service.request.BlackDuckRequest;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.rest.response.Response;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public class BlackDuckResponsesTransformer {
    private final BlackDuckHttpClient blackDuckHttpClient;
    private final BlackDuckJsonTransformer blackDuckJsonTransformer;

    public BlackDuckResponsesTransformer(BlackDuckHttpClient blackDuckHttpClient, BlackDuckJsonTransformer blackDuckJsonTransformer) {
        this.blackDuckHttpClient = blackDuckHttpClient;
        this.blackDuckJsonTransformer = blackDuckJsonTransformer;
    }

    public <T extends BlackDuckResponse> BlackDuckPageResponse<T> getSomeMatchingResponses(BlackDuckRequest<T, UrlMultipleResponses<T>> requestMultiple, Predicate<T> predicate, int totalLimit) throws IntegrationException {
        return this.getInternalMatchingResponse(requestMultiple, totalLimit, predicate);
    }

    public <T extends BlackDuckResponse> BlackDuckPageResponse<T> getAllResponses(BlackDuckRequest<T, UrlMultipleResponses<T>> requestMultiple) throws IntegrationException {
        return this.getInternalMatchingResponse(requestMultiple, Integer.MAX_VALUE, this.alwaysTrue());
    }

    public <T extends BlackDuckResponse> BlackDuckPageResponse<T> getSomeResponses(BlackDuckRequest<T, UrlMultipleResponses<T>> requestMultiple, int totalLimit) throws IntegrationException {
        return this.getInternalMatchingResponse(requestMultiple, totalLimit, this.alwaysTrue());
    }

    public <T extends BlackDuckResponse> BlackDuckPageResponse<T> getOnePageOfResponses(BlackDuckRequest<T, UrlMultipleResponses<T>> requestMultiple) throws IntegrationException {
        return this.getInternalMatchingResponse(requestMultiple, this.getLimit(requestMultiple), this.alwaysTrue());
    }

    private <T extends BlackDuckResponse> Predicate<T> alwaysTrue() {
        return blackDuckResponse -> true;
    }

    private <T extends BlackDuckResponse> BlackDuckPageResponse<T> getInternalMatchingResponse(BlackDuckRequest<T, UrlMultipleResponses<T>> requestMultiple, int maxToReturn, Predicate<T> predicate) throws IntegrationException {
        BlackDuckPageResponse blackDuckPageResponse;
        block16: {
            List<T> allResponses = new LinkedList<T>();
            int totalCount = 0;
            int limit = this.getLimit(requestMultiple);
            int offset = this.getOffset(requestMultiple);
            Response initialResponse = this.blackDuckHttpClient.execute(requestMultiple);
            try {
                this.blackDuckHttpClient.throwExceptionForError(initialResponse);
                String initialJsonResponse = initialResponse.getContentString();
                BlackDuckPageResponse<T> blackDuckPageResponse2 = this.blackDuckJsonTransformer.getResponses(initialJsonResponse, requestMultiple.getResponseClass());
                allResponses.addAll(this.matchPredicate(blackDuckPageResponse2, predicate));
                totalCount = blackDuckPageResponse2.getTotalCount();
                int totalItemsToRetrieve = Math.min(totalCount, maxToReturn);
                while (allResponses.size() < totalItemsToRetrieve && offset < totalCount) {
                    requestMultiple = this.nextPage(requestMultiple, offset += limit);
                    try {
                        Response response = this.blackDuckHttpClient.execute(requestMultiple);
                        try {
                            this.blackDuckHttpClient.throwExceptionForError(response);
                            String jsonResponse = response.getContentString();
                            blackDuckPageResponse2 = this.blackDuckJsonTransformer.getResponses(jsonResponse, requestMultiple.getResponseClass());
                            allResponses.addAll(this.matchPredicate(blackDuckPageResponse2, predicate));
                        }
                        finally {
                            if (response == null) continue;
                            response.close();
                        }
                    }
                    catch (IOException e) {
                        throw new BlackDuckIntegrationException(e);
                    }
                }
                allResponses = this.onlyReturnMaxRequested(maxToReturn, allResponses);
                blackDuckPageResponse = new BlackDuckPageResponse(totalCount, allResponses);
                if (initialResponse == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (initialResponse != null) {
                        try {
                            initialResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BlackDuckIntegrationException(e.getMessage(), e);
                }
            }
            initialResponse.close();
        }
        return blackDuckPageResponse;
    }

    private <T extends BlackDuckResponse> BlackDuckRequest<T, UrlMultipleResponses<T>> nextPage(BlackDuckRequest<T, UrlMultipleResponses<T>> blackDuckRequest, int offset) {
        BlackDuckRequestBuilder blackDuckRequestBuilder = new BlackDuckRequestBuilder(blackDuckRequest);
        blackDuckRequestBuilder.setOffset(offset);
        return new BlackDuckRequest(blackDuckRequestBuilder, blackDuckRequest.getUrlResponse());
    }

    @NotNull
    private <T extends BlackDuckResponse> List<T> onlyReturnMaxRequested(int maxToReturn, List<T> allResponses) {
        return allResponses.stream().limit(maxToReturn).collect(Collectors.toList());
    }

    private <T extends BlackDuckResponse> List<T> matchPredicate(BlackDuckPageResponse<T> blackDuckPageResponse, Predicate<T> predicate) {
        return blackDuckPageResponse.getItems().stream().filter(predicate).collect(Collectors.toList());
    }

    public int getLimit(BlackDuckRequest<?, ?> blackDuckRequest) {
        return this.retrieveValue(blackDuckRequest.getRequest().getQueryParameters()::get, "limit", 100);
    }

    public int getOffset(BlackDuckRequest<?, ?> blackDuckRequest) {
        return this.retrieveValue(blackDuckRequest.getRequest().getQueryParameters()::get, "offset", 0);
    }

    private int retrieveValue(Function<String, Set<String>> valueCollection, String key, int defaultValue) {
        return NumberUtils.toInt((String)valueCollection.apply(key).stream().findFirst().orElse(Integer.toString(defaultValue)));
    }
}

