/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.http.client.cache;

import com.blackduck.integration.blackduck.api.core.BlackDuckResponse;
import com.blackduck.integration.blackduck.api.core.response.UrlResponse;
import com.blackduck.integration.blackduck.http.client.BlackDuckHttpClient;
import com.blackduck.integration.blackduck.http.client.cache.CacheableResponse;
import com.blackduck.integration.blackduck.service.request.BlackDuckRequest;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpMethod;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.proxy.ProxyInfo;
import com.blackduck.integration.rest.request.Request;
import com.blackduck.integration.rest.response.ErrorResponse;
import com.blackduck.integration.rest.response.Response;
import com.google.gson.Gson;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

public class CachingHttpClient
implements BlackDuckHttpClient {
    private final BlackDuckHttpClient blackDuckHttpClient;
    private final Map<Request, Response> cache;

    public CachingHttpClient(BlackDuckHttpClient blackDuckHttpClient) {
        this.blackDuckHttpClient = blackDuckHttpClient;
        this.cache = Collections.synchronizedMap(new LRUMap(1000));
    }

    public void emptyCache() {
        this.cache.clear();
    }

    @Override
    public <T extends BlackDuckResponse, U extends UrlResponse<T>> Response execute(BlackDuckRequest<T, U> blackDuckRequest) throws IntegrationException {
        Request request = blackDuckRequest.getRequest();
        if (HttpMethod.GET == request.getMethod() && this.cache.containsKey(request)) {
            return this.cache.get(request);
        }
        Response response = this.blackDuckHttpClient.execute(blackDuckRequest);
        CacheableResponse cacheableResponse = new CacheableResponse(request, response, this.cache);
        return cacheableResponse;
    }

    @Override
    public Response attemptAuthentication() throws IntegrationException {
        return this.blackDuckHttpClient.attemptAuthentication();
    }

    @Override
    public boolean isAlreadyAuthenticated(HttpUriRequest request) {
        return this.blackDuckHttpClient.isAlreadyAuthenticated(request);
    }

    @Override
    public Optional<ErrorResponse> extractErrorResponse(String responseContent) {
        return this.blackDuckHttpClient.extractErrorResponse(responseContent);
    }

    @Override
    public void handleErrorResponse(HttpUriRequest request, Response response) {
        this.blackDuckHttpClient.handleErrorResponse(request, response);
    }

    @Override
    public void throwExceptionForError(Response response) throws IntegrationException {
        this.blackDuckHttpClient.throwExceptionForError(response);
    }

    @Override
    public HttpUrl getBlackDuckUrl() {
        return this.blackDuckHttpClient.getBlackDuckUrl();
    }

    @Override
    public String getUserAgentString() {
        return this.blackDuckHttpClient.getUserAgentString();
    }

    @Override
    public HttpClientBuilder getHttpClientBuilder() {
        return this.blackDuckHttpClient.getHttpClientBuilder();
    }

    @Override
    public int getTimeoutInSeconds() {
        return this.blackDuckHttpClient.getTimeoutInSeconds();
    }

    @Override
    public boolean isAlwaysTrustServerCertificate() {
        return this.blackDuckHttpClient.isAlwaysTrustServerCertificate();
    }

    @Override
    public ProxyInfo getProxyInfo() {
        return this.blackDuckHttpClient.getProxyInfo();
    }

    @Override
    public IntLogger getLogger() {
        return this.blackDuckHttpClient.getLogger();
    }

    @Override
    public Gson getGson() {
        return this.blackDuckHttpClient.getGson();
    }
}

