/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.http.client.cache;

import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.rest.exception.IntegrationRestException;
import com.blackduck.integration.rest.request.Request;
import com.blackduck.integration.rest.response.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

public class CacheableResponse
implements Response {
    private final Request request;
    private final Response response;
    private final Map<Request, Response> cache;
    private String stringResponse;

    public CacheableResponse(Request request, Response response, Map<Request, Response> cache) {
        this.request = request;
        this.response = response;
        this.cache = cache;
    }

    public HttpUriRequest getRequest() {
        return this.response.getRequest();
    }

    public int getStatusCode() {
        return this.response.getStatusCode();
    }

    public boolean isStatusCodeSuccess() {
        return this.response.isStatusCodeSuccess();
    }

    public boolean isStatusCodeError() {
        return this.response.isStatusCodeError();
    }

    public String getStatusMessage() {
        return this.response.getStatusMessage();
    }

    public InputStream getContent() throws IntegrationException {
        return this.response.getContent();
    }

    public String getContentString() throws IntegrationException {
        if (null != this.stringResponse) {
            return this.stringResponse;
        }
        this.stringResponse = this.response.getContentString();
        this.cache.put(this.request, this);
        return this.stringResponse;
    }

    public String getContentString(Charset encoding) throws IntegrationException {
        if (null != this.stringResponse) {
            return this.stringResponse;
        }
        this.stringResponse = this.response.getContentString(encoding);
        this.cache.put(this.request, this);
        return this.stringResponse;
    }

    public Long getContentLength() {
        return this.response.getContentLength();
    }

    public String getContentEncoding() {
        return this.response.getContentEncoding();
    }

    public String getContentType() {
        return this.response.getContentType();
    }

    public Map<String, String> getHeaders() {
        return this.response.getHeaders();
    }

    public String getHeaderValue(String name) {
        return this.response.getHeaderValue(name);
    }

    public CloseableHttpResponse getActualResponse() {
        return this.response.getActualResponse();
    }

    public void close() throws IOException {
        this.response.close();
    }

    public long getLastModified() throws IntegrationException {
        return this.response.getLastModified();
    }

    public void throwExceptionForError() throws IntegrationRestException {
        this.response.throwExceptionForError();
    }
}

