/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.http.client;

import com.blackduck.integration.blackduck.http.client.BlackDuckCertificateInterceptor;
import com.blackduck.integration.blackduck.http.client.BlackDuckHttpClient;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.client.IntHttpClient;
import com.blackduck.integration.rest.proxy.ProxyInfo;
import com.blackduck.integration.rest.request.Request;
import com.blackduck.integration.rest.response.Response;
import com.google.gson.Gson;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class SignatureScannerClient
extends IntHttpClient {
    public static final String PEER_CERTIFICATES = "PEER_CERTIFICATES";
    private Certificate serverCertificate;

    public SignatureScannerClient(BlackDuckHttpClient blackDuckHttpClient) {
        super(blackDuckHttpClient.getLogger(), blackDuckHttpClient.getGson(), blackDuckHttpClient.getTimeoutInSeconds(), blackDuckHttpClient.isAlwaysTrustServerCertificate(), blackDuckHttpClient.getProxyInfo());
    }

    public SignatureScannerClient(IntLogger logger, Gson gson, int timeoutInSeconds, boolean alwaysTrustServerCertificate, ProxyInfo proxyInfo) {
        super(logger, gson, timeoutInSeconds, alwaysTrustServerCertificate, proxyInfo);
    }

    public SignatureScannerClient(IntLogger logger, Gson gson, int timeoutInSeconds, ProxyInfo proxyInfo, SSLContext sslContext) {
        super(logger, gson, timeoutInSeconds, proxyInfo, sslContext);
    }

    protected void addToHttpClientBuilder(HttpClientBuilder httpClientBuilder, RequestConfig.Builder defaultRequestConfigBuilder) {
        super.addToHttpClientBuilder(httpClientBuilder, defaultRequestConfigBuilder);
        httpClientBuilder.addInterceptorLast((HttpResponseInterceptor)new BlackDuckCertificateInterceptor());
        httpClientBuilder.setConnectionReuseStrategy((httpResponse, httpContext) -> true);
    }

    @Deprecated
    public Optional<Response> executeGetRequestIfModifiedSince(Request getRequest, long timeToCheck) throws IntegrationException, IOException {
        BasicHttpContext httpContext = new BasicHttpContext();
        Optional response = super.executeGetRequestIfModifiedSince(getRequest, timeToCheck, (HttpContext)httpContext);
        this.saveCertificates((HttpContext)httpContext);
        return response;
    }

    public Response executeGetRequest(Request getRequest) throws IntegrationException {
        BasicHttpContext httpContext = new BasicHttpContext();
        Response response = super.execute(getRequest, (HttpContext)httpContext);
        this.saveCertificates((HttpContext)httpContext);
        return response;
    }

    private void saveCertificates(HttpContext httpContext) {
        Certificate[] peerCertificates = (Certificate[])httpContext.getAttribute(PEER_CERTIFICATES);
        if (null != peerCertificates) {
            this.serverCertificate = peerCertificates[0];
        }
    }

    public Certificate getServerCertificate() {
        return this.serverCertificate;
    }
}

