/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.http.client;

import com.blackduck.integration.blackduck.http.client.CookieHeaderParser;
import com.blackduck.integration.blackduck.http.client.DefaultBlackDuckHttpClient;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.client.AuthenticatingIntHttpClient;
import com.blackduck.integration.rest.credentials.Credentials;
import com.blackduck.integration.rest.proxy.ProxyInfo;
import com.blackduck.integration.rest.response.Response;
import com.blackduck.integration.rest.support.AuthenticationSupport;
import com.blackduck.integration.util.NameVersion;
import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;

public class CredentialsBlackDuckHttpClient
extends DefaultBlackDuckHttpClient {
    private final Credentials credentials;
    private final CookieHeaderParser cookieHeaderParser;

    public CredentialsBlackDuckHttpClient(IntLogger logger, Gson gson, int timeout, boolean alwaysTrustServerCertificate, ProxyInfo proxyInfo, HttpUrl blackDuckUrl, NameVersion solutionDetails, AuthenticationSupport authenticationSupport, Credentials credentials, CookieHeaderParser cookieHeaderParser) {
        super(logger, gson, timeout, alwaysTrustServerCertificate, proxyInfo, blackDuckUrl, solutionDetails, authenticationSupport);
        this.credentials = credentials;
        this.cookieHeaderParser = cookieHeaderParser;
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials cannot be null.");
        }
    }

    @Override
    public Response attemptAuthentication() throws IntegrationException {
        ArrayList<BasicNameValuePair> bodyValues = new ArrayList<BasicNameValuePair>();
        bodyValues.add(new BasicNameValuePair("j_username", (String)this.credentials.getUsername().orElse(null)));
        bodyValues.add(new BasicNameValuePair("j_password", (String)this.credentials.getPassword().orElse(null)));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(bodyValues, StandardCharsets.UTF_8);
        return this.authenticationSupport.attemptAuthentication((AuthenticatingIntHttpClient)this, this.getBlackDuckUrl(), "j_spring_security_check", (HttpEntity)entity);
    }

    protected void completeAuthenticationRequest(HttpUriRequest request, Response response) {
        if (response.isStatusCodeSuccess()) {
            CloseableHttpResponse actualResponse = response.getActualResponse();
            Optional<String> token = this.cookieHeaderParser.parseBearerToken(actualResponse.getAllHeaders());
            this.authenticationSupport.addBearerToken(this.logger, request, (AuthenticatingIntHttpClient)this, token);
        }
    }
}

