/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.http.client;

import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;

public class CookieHeaderParser {
    public static final String SET_COOKIE = "SET-COOKIE";
    public static final String AUTHORIZATION_BEARER_PREFIX = "AUTHORIZATION_BEARER=";
    public static final String HEADER_VALUE_SEPARATOR = ";";

    public Optional<String> parseBearerToken(Header[] allHeaders) {
        return Arrays.stream(allHeaders).filter(header -> SET_COOKIE.equalsIgnoreCase(header.getName())).filter(header -> header.getValue().contains(AUTHORIZATION_BEARER_PREFIX)).findFirst().map(header -> this.getToken(header.getValue()));
    }

    private String getToken(String headerValue) {
        if (headerValue.contains(HEADER_VALUE_SEPARATOR)) {
            return StringUtils.substringBetween((String)headerValue, (String)AUTHORIZATION_BEARER_PREFIX, (String)HEADER_VALUE_SEPARATOR);
        }
        return StringUtils.substringAfter((String)headerValue, (String)AUTHORIZATION_BEARER_PREFIX);
    }
}

