/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.http.client;

import java.net.URI;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.protocol.HttpContext;

public class BlackDuckRedirectStrategy
implements RedirectStrategy {
    private LaxRedirectStrategy baseRedirectStrategy = new LaxRedirectStrategy();

    public boolean isRedirected(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        int status = httpResponse.getStatusLine().getStatusCode();
        if (status == 308) {
            return true;
        }
        return this.baseRedirectStrategy.isRedirected(httpRequest, httpResponse, httpContext);
    }

    public HttpUriRequest getRedirect(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        int status = httpResponse.getStatusLine().getStatusCode();
        if (status == 308) {
            URI uri = this.baseRedirectStrategy.getLocationURI(httpRequest, httpResponse, httpContext);
            return RequestBuilder.copy((HttpRequest)httpRequest).setUri(uri).build();
        }
        return this.baseRedirectStrategy.getRedirect(httpRequest, httpResponse, httpContext);
    }
}

