/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.http.client;

import com.blackduck.integration.blackduck.http.client.DefaultBlackDuckHttpClient;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.client.AuthenticatingIntHttpClient;
import com.blackduck.integration.rest.proxy.ProxyInfo;
import com.blackduck.integration.rest.response.Response;
import com.blackduck.integration.rest.support.AuthenticationSupport;
import com.blackduck.integration.util.NameVersion;
import com.google.gson.Gson;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpUriRequest;

public class ApiTokenBlackDuckHttpClient
extends DefaultBlackDuckHttpClient {
    private final String apiToken;

    public ApiTokenBlackDuckHttpClient(IntLogger logger, Gson gson, int timeout, boolean alwaysTrustServerCertificate, ProxyInfo proxyInfo, HttpUrl blackDuckUrl, NameVersion solutionDetails, AuthenticationSupport authenticationSupport, String apiToken) {
        super(logger, gson, timeout, alwaysTrustServerCertificate, proxyInfo, blackDuckUrl, solutionDetails, authenticationSupport);
        this.apiToken = apiToken;
        if (StringUtils.isBlank((CharSequence)apiToken)) {
            throw new IllegalArgumentException("No API token was found.");
        }
    }

    @Override
    public final Response attemptAuthentication() throws IntegrationException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "token " + this.apiToken);
        return this.authenticationSupport.attemptAuthentication((AuthenticatingIntHttpClient)this, this.getBlackDuckUrl(), "api/tokens/authenticate", headers);
    }

    protected void completeAuthenticationRequest(HttpUriRequest request, Response response) {
        this.authenticationSupport.completeTokenAuthenticationRequest(request, response, this.logger, this.getGson(), (AuthenticatingIntHttpClient)this, "bearerToken");
    }
}

