/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.http;

import com.blackduck.integration.blackduck.api.core.BlackDuckResponse;
import com.blackduck.integration.blackduck.api.core.response.UrlMultipleResponses;
import com.blackduck.integration.blackduck.api.core.response.UrlSingleResponse;
import com.blackduck.integration.blackduck.api.manual.response.BlackDuckResponseResponse;
import com.blackduck.integration.blackduck.api.manual.response.BlackDuckStringResponse;
import com.blackduck.integration.blackduck.http.BlackDuckPageDefinition;
import com.blackduck.integration.blackduck.http.BlackDuckQuery;
import com.blackduck.integration.blackduck.http.BlackDuckRequestFilter;
import com.blackduck.integration.blackduck.service.request.BlackDuckMultipleRequest;
import com.blackduck.integration.blackduck.service.request.BlackDuckRequest;
import com.blackduck.integration.blackduck.service.request.BlackDuckRequestBuilderEditor;
import com.blackduck.integration.blackduck.service.request.BlackDuckResponseRequest;
import com.blackduck.integration.blackduck.service.request.BlackDuckSingleRequest;
import com.blackduck.integration.blackduck.service.request.BlackDuckStringRequest;
import com.blackduck.integration.rest.HttpMethod;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.body.BodyContent;
import com.blackduck.integration.rest.body.FileBodyContent;
import com.blackduck.integration.rest.body.MapBodyContent;
import com.blackduck.integration.rest.body.MultipartBodyContent;
import com.blackduck.integration.rest.body.ObjectBodyContent;
import com.blackduck.integration.rest.body.StringBodyContent;
import com.blackduck.integration.rest.request.Request;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.entity.ContentType;

public class BlackDuckRequestBuilder {
    public static final String LIMIT_PARAMETER = "limit";
    public static final String OFFSET_PARAMETER = "offset";
    public static final String Q_PARAMETER = "q";
    public static final String FILTER_PARAMETER = "filter";
    public static final int DEFAULT_LIMIT = 100;
    public static final int DEFAULT_OFFSET = 0;
    private final Request.Builder requestBuilder;

    public BlackDuckRequestBuilder() {
        this.requestBuilder = new Request.Builder();
    }

    public BlackDuckRequestBuilder(Request.Builder requestBuilder) {
        this.requestBuilder = new Request.Builder(requestBuilder);
    }

    public BlackDuckRequestBuilder(Request request) {
        this(new Request.Builder(request));
    }

    public BlackDuckRequestBuilder(BlackDuckRequest<?, ?> blackDuckRequest) {
        this.requestBuilder = new Request.Builder(blackDuckRequest.getRequest());
    }

    public BlackDuckRequestBuilder(BlackDuckRequestBuilder blackDuckRequestBuilder) {
        this(blackDuckRequestBuilder.requestBuilder);
    }

    public Request build() {
        return (Request)this.requestBuilder.build();
    }

    public <T extends BlackDuckResponse> BlackDuckMultipleRequest<T> buildBlackDuckRequest(UrlMultipleResponses<T> urlMultipleResponses) {
        return new BlackDuckMultipleRequest<T>(this, urlMultipleResponses);
    }

    public <T extends BlackDuckResponse> BlackDuckSingleRequest<T> buildBlackDuckRequest(UrlSingleResponse<T> urlSingleResponse) {
        return new BlackDuckSingleRequest<T>(this, urlSingleResponse);
    }

    public BlackDuckStringRequest buildBlackDuckStringRequest(HttpUrl url) {
        return new BlackDuckStringRequest(this, (UrlSingleResponse<BlackDuckStringResponse>)new UrlSingleResponse(url, BlackDuckStringResponse.class));
    }

    public BlackDuckResponseRequest buildBlackDuckResponseRequest(HttpUrl url) {
        return new BlackDuckResponseRequest(this, (UrlSingleResponse<BlackDuckResponseResponse>)new UrlSingleResponse(url, BlackDuckResponseResponse.class));
    }

    public BlackDuckRequestBuilder url(HttpUrl url) {
        this.requestBuilder.url(url);
        return this;
    }

    public BlackDuckRequestBuilder setLimitAndOffset(int limit, int offset) {
        return this.setBlackDuckPageDefinition(new BlackDuckPageDefinition(limit, offset));
    }

    public BlackDuckRequestBuilder setBlackDuckPageDefinition(BlackDuckPageDefinition blackDuckPageDefinition) {
        this.setLimit(blackDuckPageDefinition.getLimit());
        return this.setOffset(blackDuckPageDefinition.getOffset());
    }

    public BlackDuckRequestBuilder setLimit(int limit) {
        this.requestBuilder.setQueryParameter(LIMIT_PARAMETER, String.valueOf(limit));
        return this;
    }

    public BlackDuckRequestBuilder setOffset(int offset) {
        this.requestBuilder.setQueryParameter(OFFSET_PARAMETER, String.valueOf(offset));
        return this;
    }

    public BlackDuckRequestBuilder addBlackDuckQuery(BlackDuckQuery blackDuckQuery) {
        this.requestBuilder.addQueryParameter(Q_PARAMETER, blackDuckQuery.getParameter());
        return this;
    }

    public BlackDuckRequestBuilder addBlackDuckFilter(BlackDuckRequestFilter blackDuckRequestFilter) {
        if (blackDuckRequestFilter != null) {
            blackDuckRequestFilter.getFilterParameters().forEach(parameter -> this.requestBuilder.addQueryParameter(FILTER_PARAMETER, parameter));
        }
        return this;
    }

    public BlackDuckRequestBuilder method(HttpMethod method) {
        this.requestBuilder.method(method);
        return this;
    }

    public BlackDuckRequestBuilder acceptMimeType(String acceptHeader) {
        this.addHeader("Accept", acceptHeader);
        return this;
    }

    public BlackDuckRequestBuilder bodyEncoding(Charset bodyEncoding) {
        this.requestBuilder.bodyEncoding(bodyEncoding);
        return this;
    }

    public BlackDuckRequestBuilder queryParameters(Map<String, Set<String>> queryParameters) {
        this.requestBuilder.queryParameters(queryParameters);
        return this;
    }

    public BlackDuckRequestBuilder addQueryParameter(String key, String value) {
        this.requestBuilder.addQueryParameter(key, value);
        return this;
    }

    public BlackDuckRequestBuilder headers(Map<String, String> headers) {
        this.requestBuilder.headers(headers);
        return this;
    }

    public BlackDuckRequestBuilder addHeader(String key, String value) {
        this.requestBuilder.addHeader(key, value);
        return this;
    }

    public BlackDuckRequestBuilder bodyContent(BodyContent bodyContent) {
        this.requestBuilder.bodyContent(bodyContent);
        return this;
    }

    public BlackDuckRequestBuilder apply(BlackDuckRequestBuilderEditor editor) {
        editor.edit(this);
        return this;
    }

    public BlackDuckRequestBuilder apply(List<BlackDuckRequestBuilderEditor> editors) {
        for (BlackDuckRequestBuilderEditor editor : editors) {
            editor.edit(this);
        }
        return this;
    }

    public BlackDuckRequestBuilder commonGet() {
        this.setLimitAndOffset(100, 0);
        return this.get();
    }

    public BlackDuckRequestBuilder get() {
        return this.method(HttpMethod.GET);
    }

    public BlackDuckRequestBuilder postFile(File bodyContentFile, ContentType contentType) {
        return this.postBodyContent((BodyContent)new FileBodyContent(bodyContentFile, contentType));
    }

    public BlackDuckRequestBuilder postMap(Map<String, String> bodyContentMap, Charset encoding) {
        return this.postBodyContent((BodyContent)new MapBodyContent(bodyContentMap, encoding));
    }

    public BlackDuckRequestBuilder postMultipart(Map<String, File> bodyContentFileMap, Map<String, String> bodyContentStringMap) {
        return this.postBodyContent((BodyContent)new MultipartBodyContent(bodyContentFileMap, bodyContentStringMap));
    }

    public BlackDuckRequestBuilder postString(String bodyContent, ContentType contentType) {
        return this.postBodyContent((BodyContent)new StringBodyContent(bodyContent, contentType));
    }

    public BlackDuckRequestBuilder postObject(Object bodyContent, ContentType contentType) {
        return this.postBodyContent((BodyContent)new ObjectBodyContent(bodyContent, contentType));
    }

    public BlackDuckRequestBuilder postBodyContent(BodyContent bodyContent) {
        this.post();
        return this.bodyContent(bodyContent);
    }

    public BlackDuckRequestBuilder post() {
        return this.method(HttpMethod.POST);
    }

    public BlackDuckRequestBuilder putString(String bodyContent, ContentType contentType) {
        return this.putBodyContent((BodyContent)new StringBodyContent(bodyContent, contentType));
    }

    public BlackDuckRequestBuilder putObject(Object bodyContent, ContentType contentType) {
        return this.putBodyContent((BodyContent)new ObjectBodyContent(bodyContent, contentType));
    }

    public BlackDuckRequestBuilder putBodyContent(BodyContent bodyContent) {
        this.put();
        return this.bodyContent(bodyContent);
    }

    public BlackDuckRequestBuilder put() {
        return this.method(HttpMethod.PUT);
    }

    public HttpUrl getUrl() {
        return this.requestBuilder.getUrl();
    }

    public HttpMethod getMethod() {
        return this.requestBuilder.getMethod();
    }

    public String getAcceptMimeType() {
        return (String)this.requestBuilder.getHeaders().get("Accept");
    }

    public Charset getBodyEncoding() {
        return this.requestBuilder.getBodyEncoding();
    }

    public Map<String, Set<String>> getQueryParameters() {
        return this.requestBuilder.getQueryParameters();
    }

    public Map<String, String> getHeaders() {
        return this.requestBuilder.getHeaders();
    }

    public BodyContent getBodyContent() {
        return this.requestBuilder.getBodyContent();
    }
}

