/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.configuration;

import com.blackduck.integration.blackduck.configuration.BlackDuckConnectionResult;
import com.blackduck.integration.blackduck.configuration.BlackDuckServerConfigBuilder;
import com.blackduck.integration.blackduck.configuration.BlackDuckServerConfigKeys;
import com.blackduck.integration.blackduck.http.client.ApiTokenBlackDuckHttpClient;
import com.blackduck.integration.blackduck.http.client.BlackDuckHttpClient;
import com.blackduck.integration.blackduck.http.client.CookieHeaderParser;
import com.blackduck.integration.blackduck.http.client.CredentialsBlackDuckHttpClient;
import com.blackduck.integration.blackduck.http.client.cache.CachingHttpClient;
import com.blackduck.integration.blackduck.service.BlackDuckServicesFactory;
import com.blackduck.integration.builder.Buildable;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.log.SilentIntLogger;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.credentials.Credentials;
import com.blackduck.integration.rest.proxy.ProxyInfo;
import com.blackduck.integration.rest.response.ErrorResponse;
import com.blackduck.integration.rest.response.Response;
import com.blackduck.integration.rest.support.AuthenticationSupport;
import com.blackduck.integration.util.IntEnvironmentVariables;
import com.blackduck.integration.util.NameVersion;
import com.blackduck.integration.util.Stringable;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;

public class BlackDuckServerConfig
extends Stringable
implements Buildable {
    private final HttpUrl blackDuckUrl;
    private final NameVersion solutionDetails;
    private final int timeoutSeconds;
    private final Credentials credentials;
    private final String apiToken;
    private final ProxyInfo proxyInfo;
    private final boolean alwaysTrustServerCertificate;
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final Gson gson;
    private final ObjectMapper objectMapper;
    private final AuthenticationSupport authenticationSupport;
    private final CookieHeaderParser cookieHeaderParser;
    private final ExecutorService executorService;

    @Deprecated
    public static BlackDuckServerConfigBuilder newBuilder() {
        return new BlackDuckServerConfigBuilder(BlackDuckServerConfigKeys.KEYS.all);
    }

    public static BlackDuckServerConfigBuilder newApiTokenBuilder() {
        return new BlackDuckServerConfigBuilder(BlackDuckServerConfigKeys.KEYS.apiToken);
    }

    public static BlackDuckServerConfigBuilder newCredentialsBuilder() {
        return new BlackDuckServerConfigBuilder(BlackDuckServerConfigKeys.KEYS.credentials);
    }

    BlackDuckServerConfig(HttpUrl url, NameVersion solutionDetails, int timeoutSeconds, Credentials credentials, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate, IntEnvironmentVariables intEnvironmentVariables, Gson gson, ObjectMapper objectMapper, AuthenticationSupport authenticationSupport, CookieHeaderParser cookieHeaderParser, ExecutorService executorService) {
        this(url, solutionDetails, timeoutSeconds, proxyInfo, alwaysTrustServerCertificate, intEnvironmentVariables, gson, objectMapper, authenticationSupport, cookieHeaderParser, executorService, credentials, null);
    }

    BlackDuckServerConfig(HttpUrl url, NameVersion solutionDetails, int timeoutSeconds, String apiToken, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate, IntEnvironmentVariables intEnvironmentVariables, Gson gson, ObjectMapper objectMapper, AuthenticationSupport authenticationSupport, ExecutorService executorService) {
        this(url, solutionDetails, timeoutSeconds, proxyInfo, alwaysTrustServerCertificate, intEnvironmentVariables, gson, objectMapper, authenticationSupport, null, executorService, null, apiToken);
    }

    private BlackDuckServerConfig(HttpUrl url, NameVersion solutionDetails, int timeoutSeconds, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate, IntEnvironmentVariables intEnvironmentVariables, Gson gson, ObjectMapper objectMapper, AuthenticationSupport authenticationSupport, CookieHeaderParser cookieHeaderParser, ExecutorService executorService, Credentials credentials, String apiToken) {
        this.blackDuckUrl = url;
        this.solutionDetails = solutionDetails;
        this.credentials = credentials;
        this.apiToken = apiToken;
        this.timeoutSeconds = timeoutSeconds;
        this.proxyInfo = proxyInfo;
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.gson = gson;
        this.objectMapper = objectMapper;
        this.authenticationSupport = authenticationSupport;
        this.cookieHeaderParser = cookieHeaderParser;
        this.executorService = executorService;
    }

    public boolean shouldUseProxyForBlackDuck() {
        return this.proxyInfo != null && this.proxyInfo.shouldUseProxy();
    }

    public void print(IntLogger logger) {
        if (this.getBlackDuckUrl() != null) {
            logger.alwaysLog("--> Black Duck Server Url: " + this.getBlackDuckUrl());
        }
        if (this.getSolutionDetails() != null) {
            logger.alwaysLog("--> Solution Name: " + this.getSolutionDetails().getName());
            logger.alwaysLog("--> Solution Version: " + this.getSolutionDetails().getVersion());
        }
        if (this.getCredentials().isPresent() && this.getCredentials().get().getUsername().isPresent()) {
            logger.alwaysLog("--> Black Duck User: " + (String)this.getCredentials().get().getUsername().get());
        }
        if (StringUtils.isNotBlank((CharSequence)this.apiToken)) {
            logger.alwaysLog("--> Black Duck API Token Used");
        }
        if (this.alwaysTrustServerCertificate) {
            logger.alwaysLog("--> Trust Black Duck certificate: " + this.isAlwaysTrustServerCertificate());
        }
        if (this.proxyInfo != null && this.proxyInfo.shouldUseProxy()) {
            if (StringUtils.isNotBlank((CharSequence)this.proxyInfo.getHost().orElse(null))) {
                logger.alwaysLog("--> Proxy Host: " + this.proxyInfo.getHost());
            }
            if (this.proxyInfo.getPort() > 0) {
                logger.alwaysLog("--> Proxy Port: " + this.proxyInfo.getPort());
            }
            if (StringUtils.isNotBlank((CharSequence)this.proxyInfo.getUsername().orElse(null))) {
                logger.alwaysLog("--> Proxy Username: " + this.proxyInfo.getUsername());
            }
        }
    }

    public boolean canConnect() {
        return this.canConnect((IntLogger)new SilentIntLogger());
    }

    public boolean canConnect(IntLogger logger) {
        BlackDuckConnectionResult connectionResult = this.attemptConnection(logger);
        return connectionResult.isSuccess();
    }

    public BlackDuckConnectionResult attemptConnection(IntLogger logger) {
        String errorMessage = null;
        Exception exception = null;
        int httpStatusCode = 0;
        BlackDuckHttpClient blackDuckHttpClient = null;
        try {
            blackDuckHttpClient = this.createBlackDuckHttpClient(logger);
            try (Response response = blackDuckHttpClient.attemptAuthentication();){
                httpStatusCode = response.getStatusCode();
                if (response.isStatusCodeError()) {
                    String httpResponseContent = response.getContentString();
                    Optional<ErrorResponse> errorResponse = blackDuckHttpClient.extractErrorResponse(httpResponseContent);
                    errorMessage = errorResponse.isPresent() ? errorResponse.get().getErrorMessage() : "The connection was not successful for an unknown reason. If an api token is being used, it could be incorrect.";
                }
            }
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
            exception = e;
        }
        if (null != errorMessage || null == blackDuckHttpClient) {
            logger.error(errorMessage);
            return BlackDuckConnectionResult.BLACK_DUCK_FAILURE(httpStatusCode, errorMessage, exception);
        }
        logger.info("A successful connection was made.");
        return BlackDuckConnectionResult.BLACK_DUCK_SUCCESS(httpStatusCode, blackDuckHttpClient);
    }

    public BlackDuckServicesFactory createBlackDuckServicesFactory(IntLogger logger) {
        BlackDuckHttpClient blackDuckHttpClient = this.createBlackDuckHttpClient(logger);
        return this.createBlackDuckServicesFactory(blackDuckHttpClient, logger);
    }

    public BlackDuckServicesFactory createCachedBlackDuckServicesFactory(IntLogger logger) {
        CachingHttpClient blackDuckHttpClient = this.createCacheHttpClient(logger);
        return this.createBlackDuckServicesFactory(blackDuckHttpClient, logger);
    }

    public BlackDuckServicesFactory createBlackDuckServicesFactory(BlackDuckHttpClient blackDuckHttpClient, IntLogger logger) {
        return new BlackDuckServicesFactory(this.intEnvironmentVariables, this.executorService, logger, blackDuckHttpClient, this.gson, this.objectMapper);
    }

    public BlackDuckHttpClient createBlackDuckHttpClient(IntLogger logger) {
        if (this.usingApiToken()) {
            return this.createApiTokenBlackDuckHttpClient(logger);
        }
        return this.createCredentialsBlackDuckHttpClient(logger);
    }

    public CachingHttpClient createCacheHttpClient(IntLogger logger) {
        BlackDuckHttpClient blackDuckHttpClient = this.createBlackDuckHttpClient(logger);
        return new CachingHttpClient(blackDuckHttpClient);
    }

    public CredentialsBlackDuckHttpClient createCredentialsBlackDuckHttpClient(IntLogger logger) {
        return new CredentialsBlackDuckHttpClient(logger, this.gson, this.getTimeout(), this.isAlwaysTrustServerCertificate(), this.getProxyInfo(), this.getBlackDuckUrl(), this.getSolutionDetails(), this.authenticationSupport, this.getCredentials().orElse(null), this.cookieHeaderParser);
    }

    public ApiTokenBlackDuckHttpClient createApiTokenBlackDuckHttpClient(IntLogger logger) {
        return new ApiTokenBlackDuckHttpClient(logger, this.gson, this.getTimeout(), this.isAlwaysTrustServerCertificate(), this.getProxyInfo(), this.getBlackDuckUrl(), this.getSolutionDetails(), this.authenticationSupport, this.getApiToken().orElse(null));
    }

    public boolean usingApiToken() {
        return StringUtils.isNotBlank((CharSequence)this.apiToken);
    }

    public HttpUrl getBlackDuckUrl() {
        return this.blackDuckUrl;
    }

    public NameVersion getSolutionDetails() {
        return this.solutionDetails;
    }

    public Optional<Credentials> getCredentials() {
        return Optional.ofNullable(this.credentials);
    }

    public Optional<String> getApiToken() {
        return Optional.ofNullable(this.apiToken);
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public int getTimeout() {
        return this.timeoutSeconds;
    }

    public boolean isAlwaysTrustServerCertificate() {
        return this.alwaysTrustServerCertificate;
    }
}

