/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.upload;

import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.util.NameVersion;
import java.io.File;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class UploadTarget {
    @Nullable
    private final NameVersion projectAndVersion;
    private final String codeLocationName;
    private final File uploadFile;
    private final String mediaType;
    private String scanId;
    private HttpUrl blackDuckUrl;

    private UploadTarget(@Nullable NameVersion projectAndVersion, String codeLocationName, File uploadFile, String mediaType) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)codeLocationName)) {
            throw new IllegalArgumentException("An UploadTarget must have a non-blank codeLocationName.");
        }
        this.projectAndVersion = projectAndVersion;
        this.codeLocationName = codeLocationName;
        this.uploadFile = uploadFile;
        this.mediaType = mediaType;
    }

    public void setScanId(String scanId) {
        this.scanId = scanId;
    }

    public String getScanId() {
        return this.scanId;
    }

    public void setBlackDuckUrl(HttpUrl blackDuckUrl) {
        this.blackDuckUrl = blackDuckUrl;
    }

    public HttpUrl getBlackDuckUrl() {
        return this.blackDuckUrl;
    }

    public static UploadTarget createDefault(String codeLocationName, File uploadFile) {
        return UploadTarget.createDefault(null, codeLocationName, uploadFile);
    }

    public static UploadTarget createDefault(@Nullable NameVersion projectAndVersion, String codeLocationName, File uploadFile) {
        return new UploadTarget(projectAndVersion, codeLocationName, uploadFile, "application/ld+json");
    }

    public static UploadTarget createWithMediaType(String codeLocationName, File uploadFile, String mediaType) {
        return UploadTarget.createWithMediaType(null, codeLocationName, uploadFile, mediaType);
    }

    public static UploadTarget createWithMediaType(@Nullable NameVersion projectAndVersion, String codeLocationName, File uploadFile, String mediaType) {
        return new UploadTarget(projectAndVersion, codeLocationName, uploadFile, mediaType);
    }

    public Optional<NameVersion> getProjectAndVersion() {
        return Optional.ofNullable(this.projectAndVersion);
    }

    public String getCodeLocationName() {
        return this.codeLocationName;
    }

    public File getUploadFile() {
        return this.uploadFile;
    }

    public String getMediaType() {
        return this.mediaType;
    }
}

