/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.signaturescanner.command;

import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ApiScannerInstaller;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ScanPaths;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ScanPathsUtility;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.blackduck.http.client.SignatureScannerClient;
import com.blackduck.integration.blackduck.keystore.KeyStoreHelper;
import com.blackduck.integration.blackduck.service.dataservice.BlackDuckRegistrationService;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.request.Request;
import com.blackduck.integration.rest.response.Response;
import com.blackduck.integration.util.CleanupZipExpander;
import com.blackduck.integration.util.OperatingSystemType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.cert.Certificate;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ZipApiScannerInstaller
extends ApiScannerInstaller {
    public static final String DEFAULT_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX = "download/scan.cli.zip";
    public static final String WINDOWS_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX = "download/scan.cli-windows.zip";
    public static final String MAC_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX = "download/scan.cli-macosx.zip";
    private final IntLogger logger;
    private final SignatureScannerClient signatureScannerClient;
    private final BlackDuckRegistrationService blackDuckRegistrationService;
    private final CleanupZipExpander cleanupZipExpander;
    private final ScanPathsUtility scanPathsUtility;
    private final KeyStoreHelper keyStoreHelper;
    private final HttpUrl blackDuckServerUrl;
    private final OperatingSystemType operatingSystemType;
    private final File installDirectory;

    public ZipApiScannerInstaller(IntLogger logger, SignatureScannerClient signatureScannerClient, BlackDuckRegistrationService blackDuckRegistrationService, CleanupZipExpander cleanupZipExpander, ScanPathsUtility scanPathsUtility, KeyStoreHelper keyStoreHelper, HttpUrl blackDuckServerUrl, OperatingSystemType operatingSystemType, File installDirectory) {
        if (null == blackDuckServerUrl) {
            throw new IllegalArgumentException("A Black Duck server url must be provided.");
        }
        this.logger = logger;
        this.signatureScannerClient = signatureScannerClient;
        this.blackDuckRegistrationService = blackDuckRegistrationService;
        this.cleanupZipExpander = cleanupZipExpander;
        this.scanPathsUtility = scanPathsUtility;
        this.keyStoreHelper = keyStoreHelper;
        this.blackDuckServerUrl = blackDuckServerUrl;
        this.operatingSystemType = operatingSystemType;
        this.installDirectory = installDirectory;
    }

    @Override
    public File installOrUpdateScanner() throws BlackDuckIntegrationException {
        if (this.installDirectory.exists()) {
            try {
                ScanPaths scanPaths = this.scanPathsUtility.searchForScanPaths(this.installDirectory);
                if (!scanPaths.isManagedByLibrary()) {
                    return this.installDirectory;
                }
            }
            catch (BlackDuckIntegrationException scanPaths) {
                // empty catch block
            }
        }
        File scannerExpansionDirectory = new File(this.installDirectory, "Black_Duck_Scan_Installation");
        scannerExpansionDirectory.mkdirs();
        File versionFile = new File(scannerExpansionDirectory, "blackDuckVersion.txt");
        HttpUrl downloadUrl = this.getDownloadUrl();
        try {
            String connectedBlackDuckVersion = StringUtils.trim((String)this.blackDuckRegistrationService.getBlackDuckServerData().getVersion());
            if (!versionFile.exists()) {
                this.logger.info("No version file exists, assuming this is new installation and the signature scanner should be downloaded.");
                this.downloadSignatureScanner(scannerExpansionDirectory, downloadUrl, "");
                this.logger.debug("The version file has not been created yet so creating it now.");
                FileUtils.writeStringToFile((File)versionFile, (String)connectedBlackDuckVersion, (Charset)Charset.defaultCharset());
                return this.installDirectory;
            }
            String localScannerVersion = FileUtils.readFileToString((File)versionFile, (Charset)Charset.defaultCharset());
            this.logger.debug(String.format("Locally installed signature scanner version: %s", localScannerVersion));
            if (!connectedBlackDuckVersion.equals(localScannerVersion)) {
                this.logger.info(String.format("The signature scanner should be downloaded. Locally installed signature scanner is %s, but the connected Black Duck version is %s", localScannerVersion, connectedBlackDuckVersion));
                this.downloadSignatureScanner(scannerExpansionDirectory, downloadUrl, "");
                FileUtils.writeStringToFile((File)versionFile, (String)connectedBlackDuckVersion, (Charset)Charset.defaultCharset());
            } else {
                this.logger.debug("The Black Duck Signature Scanner version matches the connected Black Duck version - skipping download.");
            }
        }
        catch (Exception e) {
            throw new BlackDuckIntegrationException("The Black Duck Signature Scanner could not be downloaded successfully: " + e.getMessage(), e);
        }
        this.logger.info("The Black Duck Signature Scanner downloaded/found successfully: " + this.installDirectory.getAbsolutePath());
        return this.installDirectory;
    }

    @Override
    protected HttpUrl getDownloadUrl() throws BlackDuckIntegrationException {
        StringBuilder url = new StringBuilder(this.blackDuckServerUrl.string());
        if (!this.blackDuckServerUrl.string().endsWith("/")) {
            url.append("/");
        }
        if (OperatingSystemType.MAC == this.operatingSystemType) {
            url.append(MAC_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX);
        } else if (OperatingSystemType.WINDOWS == this.operatingSystemType) {
            url.append(WINDOWS_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX);
        } else {
            url.append(DEFAULT_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX);
        }
        try {
            return new HttpUrl(url.toString());
        }
        catch (IntegrationException e) {
            throw new BlackDuckIntegrationException(String.format("The Black Duck Signature Scanner url (%s) is not valid.", url.toString()));
        }
    }

    @Override
    protected String downloadSignatureScanner(File scannerExpansionDirectory, HttpUrl downloadUrl, String localScannerVersion) throws IOException, IntegrationException, ArchiveException {
        Request downloadRequest = (Request)new Request.Builder(downloadUrl).build();
        try (Response response = this.signatureScannerClient.executeGetRequest(downloadRequest);){
            this.logger.info("Downloading the Black Duck Signature Scanner.");
            try (InputStream responseStream = response.getContent();){
                this.logger.info(String.format("If your Black Duck server has changed, the contents of %s may change which could involve deleting files - please do not place items in the expansion directory as this directory is assumed to be under blackduck-common control.", scannerExpansionDirectory.getAbsolutePath()));
                this.cleanupZipExpander.expand(responseStream, scannerExpansionDirectory);
            }
            ScanPaths scanPaths = this.scanPathsUtility.searchForScanPaths(scannerExpansionDirectory.getParentFile());
            File javaExecutable = new File(scanPaths.getPathToJavaExecutable());
            File oneJar = new File(scanPaths.getPathToOneJar());
            File scanExecutable = new File(scanPaths.getPathToScanExecutable());
            javaExecutable.setExecutable(true);
            oneJar.setExecutable(true);
            scanExecutable.setExecutable(true);
            Certificate serverCertificate = this.signatureScannerClient.getServerCertificate();
            this.keyStoreHelper.updateKeyStoreWithServerCertificate(downloadUrl.url().getHost(), serverCertificate, scanPaths.getPathToCacerts());
            this.logger.info("Black Duck Signature Scanner downloaded successfully.");
        }
        return "";
    }
}

