/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.signaturescanner.command;

import com.blackduck.integration.blackduck.api.core.BlackDuckResponse;
import com.blackduck.integration.blackduck.api.core.response.UrlSingleResponse;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ApiScannerInstaller;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ScanCliMetadata;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ScanPaths;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ScanPathsUtility;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.http.client.BlackDuckHttpClient;
import com.blackduck.integration.blackduck.keystore.KeyStoreHelper;
import com.blackduck.integration.blackduck.service.request.BlackDuckRequest;
import com.blackduck.integration.blackduck.version.BlackDuckVersion;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.response.Response;
import com.blackduck.integration.util.CleanupZipExpander;
import com.blackduck.integration.util.OperatingSystemType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.io.FileUtils;

public class ToolsApiScannerInstaller
extends ApiScannerInstaller {
    public static final BlackDuckVersion MIN_BLACK_DUCK_VERSION = new BlackDuckVersion(2024, 7, 0);
    public static final BlackDuckVersion MIN_ARM_BLACK_DUCK_VERSION = new BlackDuckVersion(2025, 7, 0);
    private static final String LATEST_SCAN_CLI_TOOL_DOWNLOAD_URL = "api/tools/scan.cli.zip/versions/latest/";
    private static final String PLATFORM_PARAMETER_KEY = "platforms";
    private static final String MAC_PLATFORM_PARAMETER_VALUE = "macosx";
    private static final String LINUX_PLATFORM_PARAMETER_VALUE = "linux";
    private static final String WINDOWS_PLATFORM_PARAMETER_VALUE = "windows";
    private static final String ALPINE_PLATFORM_PARAMETER_VALUE = "alpine_linux";
    private static final String ALPINE_OS_RELEASE_PATH = "/etc/alpine-release";
    private static final String OS_RELEASE_PATH = "/etc/os-release";
    private static final String OS_RELEASE_ALTERNATE_PATH = "/usr/lib/os-release";
    private static final String ARM64_CONSTANT = "arm64";
    private static final String AARCH64_CONSTANT = "aarch64";
    private static final String X64_CONSTANT = "x64";
    private final IntLogger logger;
    private final BlackDuckHttpClient blackDuckHttpClient;
    private final CleanupZipExpander cleanupZipExpander;
    private final ScanPathsUtility scanPathsUtility;
    private final KeyStoreHelper keyStoreHelper;
    private final HttpUrl blackDuckServerUrl;
    private final OperatingSystemType operatingSystemType;
    private final File installDirectory;
    private final String osArchitecture;
    private File versionFile;

    public ToolsApiScannerInstaller(IntLogger logger, BlackDuckHttpClient blackDuckHttpClient, CleanupZipExpander cleanupZipExpander, ScanPathsUtility scanPathsUtility, KeyStoreHelper keyStoreHelper, HttpUrl blackDuckServerUrl, OperatingSystemType operatingSystemType, File installDirectory, String osArchitecture) {
        if (null == blackDuckServerUrl) {
            throw new IllegalArgumentException("A Black Duck server url must be provided.");
        }
        this.logger = logger;
        this.blackDuckHttpClient = blackDuckHttpClient;
        this.cleanupZipExpander = cleanupZipExpander;
        this.scanPathsUtility = scanPathsUtility;
        this.keyStoreHelper = keyStoreHelper;
        this.blackDuckServerUrl = blackDuckServerUrl;
        this.operatingSystemType = operatingSystemType;
        this.installDirectory = installDirectory;
        this.osArchitecture = osArchitecture;
    }

    @Override
    public File installOrUpdateScanner() throws BlackDuckIntegrationException {
        if (this.installDirectory.exists()) {
            try {
                ScanPaths scanPaths = this.scanPathsUtility.searchForScanPaths(this.installDirectory);
                if (!scanPaths.isManagedByLibrary()) {
                    return this.installDirectory;
                }
            }
            catch (BlackDuckIntegrationException scanPaths) {
                // empty catch block
            }
        }
        File scannerExpansionDirectory = new File(this.installDirectory, "Black_Duck_Scan_Installation");
        scannerExpansionDirectory.mkdirs();
        this.versionFile = new File(scannerExpansionDirectory, "blackDuckVersion.txt");
        HttpUrl downloadUrl = this.getDownloadUrl();
        File scanCliMetadataFile = this.scanPathsUtility.getMetadataFile();
        try {
            if (scanCliMetadataFile != null && scanCliMetadataFile.exists()) {
                String os;
                ScanCliMetadata scanCliMetadata = ScanCliMetadata.getMetadata(scanCliMetadataFile);
                String localScannerVersion = scanCliMetadata.getToolVersion();
                String localArchitecture = scanCliMetadata.getArch();
                if (localArchitecture.equals(ARM64_CONSTANT)) {
                    if (!this.osArchitecture.equals(AARCH64_CONSTANT) && !this.osArchitecture.equals(ARM64_CONSTANT)) {
                        localScannerVersion = "";
                    }
                } else if (localArchitecture.equals(X64_CONSTANT) && (this.osArchitecture.equals(AARCH64_CONSTANT) || this.osArchitecture.equals(ARM64_CONSTANT))) {
                    localScannerVersion = "";
                }
                if (!this.checkOSValue(os = scanCliMetadata.getOs())) {
                    localScannerVersion = "";
                }
                this.logger.debug(String.format("Locally installed signature scanner version: %s", localScannerVersion));
                scanCliMetadataFile = this.downloadSignatureScanner(scannerExpansionDirectory, downloadUrl, localScannerVersion);
            } else if (this.versionFile.exists()) {
                String localScannerVersion = FileUtils.readFileToString((File)this.versionFile, (Charset)Charset.defaultCharset());
                this.logger.debug(String.format("Locally installed signature scanner version: %s", localScannerVersion));
                this.downloadSignatureScanner(scannerExpansionDirectory, downloadUrl, localScannerVersion);
            } else {
                this.logger.info("No metadata file exists, assuming this is new installation and the signature scanner should be downloaded.");
                scanCliMetadataFile = this.downloadSignatureScanner(scannerExpansionDirectory, downloadUrl, "");
            }
        }
        catch (Exception e) {
            throw new BlackDuckIntegrationException("The Black Duck Signature Scanner could not be downloaded successfully: " + e.getMessage(), e);
        }
        this.logger.info("The Black Duck Signature Scanner downloaded/found successfully: " + this.installDirectory.getAbsolutePath());
        return this.installDirectory;
    }

    private boolean checkOSValue(String os) {
        if (os.equals(MAC_PLATFORM_PARAMETER_VALUE) && !this.operatingSystemType.equals((Object)OperatingSystemType.MAC)) {
            return false;
        }
        if (os.equals(WINDOWS_PLATFORM_PARAMETER_VALUE) && !this.operatingSystemType.equals((Object)OperatingSystemType.WINDOWS)) {
            return false;
        }
        if (os.equals(ALPINE_PLATFORM_PARAMETER_VALUE) && this.isAlpineLinux() && !this.operatingSystemType.equals((Object)OperatingSystemType.ALPINE_LINUX) && !this.operatingSystemType.equals((Object)OperatingSystemType.LINUX)) {
            return false;
        }
        return !os.equals(LINUX_PLATFORM_PARAMETER_VALUE) || this.operatingSystemType.equals((Object)OperatingSystemType.LINUX);
    }

    @Override
    protected HttpUrl getDownloadUrl() throws BlackDuckIntegrationException {
        StringBuilder url = new StringBuilder(this.blackDuckServerUrl.string());
        if (!this.blackDuckServerUrl.string().endsWith("/")) {
            url.append("/");
        }
        url.append(LATEST_SCAN_CLI_TOOL_DOWNLOAD_URL);
        String platform = OperatingSystemType.ALPINE_LINUX == this.operatingSystemType ? ALPINE_PLATFORM_PARAMETER_VALUE : (OperatingSystemType.MAC == this.operatingSystemType ? MAC_PLATFORM_PARAMETER_VALUE : (OperatingSystemType.WINDOWS == this.operatingSystemType ? WINDOWS_PLATFORM_PARAMETER_VALUE : (OperatingSystemType.LINUX == this.operatingSystemType && this.isAlpineLinux() ? ALPINE_PLATFORM_PARAMETER_VALUE : LINUX_PLATFORM_PARAMETER_VALUE)));
        if (this.osArchitecture.equals(AARCH64_CONSTANT) || this.osArchitecture.equals(ARM64_CONSTANT)) {
            platform = platform + "_" + ARM64_CONSTANT;
        }
        url.append("platforms/" + platform);
        try {
            return new HttpUrl(url.toString());
        }
        catch (IntegrationException e) {
            throw new BlackDuckIntegrationException(String.format("The Black Duck Signature Scanner url (%s) is not valid.", url));
        }
    }

    private boolean isAlpineLinux() {
        if (!this.osArchitecture.equals(AARCH64_CONSTANT) && !this.osArchitecture.equals(ARM64_CONSTANT)) {
            return false;
        }
        if (new File(ALPINE_OS_RELEASE_PATH).exists()) {
            return true;
        }
        if (new File(OS_RELEASE_PATH).exists()) {
            try {
                String osRelease = new String(Files.readAllBytes(Paths.get(OS_RELEASE_PATH, new String[0])));
                return osRelease.toLowerCase().contains("alpine");
            }
            catch (IOException e) {
                this.logger.trace("There was a problem reading the os-release file", (Throwable)e);
                return false;
            }
        }
        if (new File(OS_RELEASE_ALTERNATE_PATH).exists()) {
            try {
                String osRelease = new String(Files.readAllBytes(Paths.get(OS_RELEASE_ALTERNATE_PATH, new String[0])));
                return osRelease.toLowerCase().contains("alpine");
            }
            catch (IOException e) {
                this.logger.trace("There was a problem reading the os-release file", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    protected File downloadSignatureScanner(File scannerExpansionDirectory, HttpUrl downloadUrl, String localScannerVersion) throws IOException, IntegrationException, ArchiveException {
        BlackDuckRequestBuilder requestBuilder = new BlackDuckRequestBuilder().url(downloadUrl).addHeader("Version", localScannerVersion);
        if (!localScannerVersion.isEmpty()) {
            requestBuilder.addHeader("Accept-Version", "ANY");
        }
        BlackDuckRequest<BlackDuckResponse, UrlSingleResponse<BlackDuckResponse>> downloadRequest = BlackDuckRequest.createSingleRequest(requestBuilder, downloadUrl, BlackDuckResponse.class);
        try (Response response = this.blackDuckHttpClient.execute(downloadRequest);){
            if (response.isStatusCodeSuccess()) {
                String latestScannerVersion = response.getHeaderValue("Version");
                if (!localScannerVersion.isEmpty()) {
                    this.logger.info(String.format("The signature scanner should be downloaded. Locally installed signature scanner is %s, but the latest version is %s", localScannerVersion, latestScannerVersion));
                }
                this.logger.info("Downloading the Black Duck Signature Scanner.");
                try (InputStream responseStream = response.getContent();){
                    this.logger.info(String.format("If the Signature Scanner on your Black Duck server has changed, the contents of %s may change which could involve deleting files - please do not place items in the expansion directory as this directory is assumed to be under blackduck-common control.", scannerExpansionDirectory.getAbsolutePath()));
                    this.cleanupZipExpander.expand(responseStream, scannerExpansionDirectory);
                }
                ScanPaths scanPaths = this.scanPathsUtility.searchForScanPaths(scannerExpansionDirectory.getParentFile());
                File javaExecutable = new File(scanPaths.getPathToJavaExecutable());
                File oneJar = new File(scanPaths.getPathToOneJar());
                File scanExecutable = new File(scanPaths.getPathToScanExecutable());
                javaExecutable.setExecutable(true);
                oneJar.setExecutable(true);
                scanExecutable.setExecutable(true);
                this.connectAndGetServerCertificate(downloadUrl, scanPaths);
                FileUtils.writeStringToFile((File)this.versionFile, (String)latestScannerVersion, (Charset)Charset.defaultCharset());
                this.logger.info("Black Duck Signature Scanner downloaded successfully.");
                File file = this.scanPathsUtility.getMetadataFile();
                return file;
            }
            if (response.getStatusCode() == 304) {
                this.logger.debug("Locally installed Signature Scanner version is up to date - skipping download.");
                ScanPaths scanPaths = this.scanPathsUtility.searchForScanPaths(scannerExpansionDirectory.getParentFile());
                this.connectAndGetServerCertificate(downloadUrl, scanPaths);
                File file = this.scanPathsUtility.getMetadataFile();
                return file;
            }
            this.logger.debug("Unable to download Signature Scanner. Response code: " + response.getStatusCode() + " " + response.getStatusMessage());
            throw new IntegrationException("Unable to download Black Duck Signature Scanner. Response code: " + response.getStatusCode() + " " + response.getStatusMessage());
        }
    }

    private void connectAndGetServerCertificate(HttpUrl httpsServer, ScanPaths scanPaths) {
        HttpsURLConnection httpsConnection = null;
        try {
            httpsConnection = (HttpsURLConnection)httpsServer.url().openConnection();
            httpsConnection.connect();
            Certificate[] certificates = httpsConnection.getServerCertificates();
            httpsConnection.disconnect();
            if (certificates.length <= 0) {
                throw new IOException();
            }
            this.keyStoreHelper.updateKeyStoreWithServerCertificate(httpsServer.url().getHost(), certificates[0], scanPaths.getPathToCacerts());
        }
        catch (SSLHandshakeException e) {
            this.logger.warn("Automatically trusting server certificates - not recommended for production use.");
        }
        catch (IOException e) {
            this.logger.errorAndDebug("Could not get Black Duck server certificate which is required for managing the local keystore - communicating to the server will have to be configured manually: " + e.getMessage(), (Throwable)e);
        }
    }
}

