/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.signaturescanner.command;

import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ScanPaths;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.function.ThrowingSupplier;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.util.IntEnvironmentVariables;
import com.blackduck.integration.util.OperatingSystemType;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ScanPathsUtility {
    public static final String STANDARD_OUT_FILENAME = "CLI_Output.txt";
    public static final String BDS_JAVA_HOME = "BDS_JAVA_HOME";
    private static final String JAVA_PATH_FORMAT = "bin" + File.separator + "%s";
    private static final String WINDOWS_JAVA_PATH = String.format(JAVA_PATH_FORMAT, "java.exe");
    private static final String OTHER_JAVA_PATH = String.format(JAVA_PATH_FORMAT, "java");
    private static final String CACERTS_PATH = "lib" + File.separator + "security" + File.separator + "cacerts";
    private static final String STANDALONE_JAR_PATH = "cache" + File.separator + "scan.cli.impl-standalone.jar";
    private static final String METADATA_FILE_NAME = "metadata.json";
    private static final FileFilter EXCLUDE_NON_SCAN_CLI_DIRECTORIES_FILTER = file -> !file.isHidden() && !file.getName().contains("windows") && file.isDirectory();
    private static final FileFilter JRE_DIRECTORY_FILTER = file -> "jre".equalsIgnoreCase(file.getName()) && file.isDirectory();
    private static final FileFilter LIB_DIRECTORY_FILTER = file -> "lib".equalsIgnoreCase(file.getName()) && file.isDirectory();
    private static final FileFilter SCAN_CLI_JAR_FILE_FILTER = file -> file.getName().startsWith("scan.cli") && file.getName().endsWith(".jar") && file.isFile();
    private final AtomicInteger defaultMultiThreadingId = new AtomicInteger(0);
    private final IntLogger logger;
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final OperatingSystemType operatingSystemType;
    private File scanCliMetadataFile;

    public ScanPathsUtility(IntLogger logger, IntEnvironmentVariables intEnvironmentVariables, OperatingSystemType operatingSystemType) {
        this.logger = logger;
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.operatingSystemType = operatingSystemType;
    }

    public ScanPaths searchForScanPaths(File directory) throws BlackDuckIntegrationException {
        if (directory == null) {
            throw new IllegalArgumentException("null is not a valid directory");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(String.format("%s is not a valid directory", directory.getAbsolutePath()));
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException(String.format("%s does not exist.", directory.getAbsolutePath()));
        }
        boolean managedByLibrary = false;
        File installDirectory = directory;
        File[] blackDuckScanInstallationDirectories = directory.listFiles(file -> "Black_Duck_Scan_Installation".equals(file.getName()));
        if (blackDuckScanInstallationDirectories.length == 1) {
            this.logger.debug("The directory structure was likely created by the installer");
            installDirectory = this.findFirstFilteredFile(blackDuckScanInstallationDirectories[0], EXCLUDE_NON_SCAN_CLI_DIRECTORIES_FILTER, "No scan.cli directories could be found in %s.");
            managedByLibrary = true;
        } else {
            this.logger.debug(String.format("The directory structure was likely created manually - be sure the jre folder exists in: %s", installDirectory.getAbsolutePath()));
        }
        File jreContentsDirectory = this.findFirstFilteredFile(installDirectory, JRE_DIRECTORY_FILTER, "Could not find the 'jre' directory in %s.");
        String pathToCacerts = this.findPathToCacerts(jreContentsDirectory);
        String pathToJavaExecutable = this.determinePathToJavaExecutable(jreContentsDirectory);
        File libDirectory = this.findFirstFilteredFile(installDirectory, LIB_DIRECTORY_FILTER, "Could not find the 'lib' directory in %s.");
        String pathToOneJar = this.findPathToStandaloneJar(libDirectory);
        String pathToScanExecutable = this.findPathToScanCliJar(libDirectory);
        this.scanCliMetadataFile = new File(installDirectory, METADATA_FILE_NAME);
        return new ScanPaths(pathToJavaExecutable, pathToCacerts, pathToOneJar, pathToScanExecutable, managedByLibrary);
    }

    public File createSpecificRunOutputDirectory(File generalOutputDirectory) throws BlackDuckIntegrationException {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss-SSS").withZone(ZoneOffset.UTC);
        String timeStringPrefix = Instant.now().atZone(ZoneOffset.UTC).format(dateTimeFormatter);
        int uniqueThreadIdSuffix = this.defaultMultiThreadingId.incrementAndGet();
        return this.createRunOutputDirectory(generalOutputDirectory, timeStringPrefix, Integer.toString(uniqueThreadIdSuffix));
    }

    public File createRunOutputDirectory(File generalOutputDirectory, String userProvidedPrefix, String userProvidedUniqueSuffix) throws BlackDuckIntegrationException {
        String signatureScanOutputDirectoryName = "BlackDuckScanOutput";
        File signatureScanOutputDirectory = new File(generalOutputDirectory, "BlackDuckScanOutput");
        String uniqueOutputDirectoryName = userProvidedPrefix + "_" + userProvidedUniqueSuffix;
        File specificRunOutputDirectory = new File(signatureScanOutputDirectory, uniqueOutputDirectoryName);
        if (!specificRunOutputDirectory.exists() && !specificRunOutputDirectory.mkdirs()) {
            throw new BlackDuckIntegrationException(String.format("Could not create the %s directory!", specificRunOutputDirectory.getAbsolutePath()));
        }
        File bdIgnoreLogsFile = new File(generalOutputDirectory, ".bdignore");
        if (!bdIgnoreLogsFile.exists()) {
            try {
                if (!bdIgnoreLogsFile.createNewFile()) {
                    throw new BlackDuckIntegrationException(String.format("Could not create the %s file!", bdIgnoreLogsFile.getAbsolutePath()));
                }
                String exclusionPattern = "/BlackDuckScanOutput/";
                Files.write(bdIgnoreLogsFile.toPath(), "/BlackDuckScanOutput/".getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new BlackDuckIntegrationException(String.format("Unexpected error creating the .bdignore file in the %s directory: %s", bdIgnoreLogsFile.getAbsolutePath(), e.getMessage()));
            }
        }
        return specificRunOutputDirectory;
    }

    public File createStandardOutFile(File specificRunOutputDirectory) throws IOException {
        File standardOutFile = new File(specificRunOutputDirectory, STANDARD_OUT_FILENAME);
        standardOutFile.createNewFile();
        return standardOutFile;
    }

    private String findPathToJavaExe(File jreContentsDirectory) throws BlackDuckIntegrationException {
        File jdkBase = this.getJdkBase(jreContentsDirectory);
        File javaExe = new File(jdkBase, OTHER_JAVA_PATH);
        if (OperatingSystemType.WINDOWS == this.operatingSystemType) {
            javaExe = new File(jdkBase, WINDOWS_JAVA_PATH);
        }
        if (!javaExe.exists() || !javaExe.isFile()) {
            throw new BlackDuckIntegrationException(String.format("The java executable does not exist at: %s", javaExe.getAbsolutePath()));
        }
        return javaExe.getAbsolutePath();
    }

    private String findPathToCacerts(File jreContentsDirectory) {
        File jdkBase = this.getJdkBase(jreContentsDirectory);
        File cacerts = new File(jdkBase, CACERTS_PATH);
        return cacerts.getAbsolutePath();
    }

    @NotNull
    private File getJdkBase(File jreContentsDirectory) {
        File jdkBase = jreContentsDirectory;
        List<String> filenames = Arrays.asList(jdkBase.list());
        if (filenames.contains("Contents")) {
            jdkBase = new File(jdkBase, "Contents");
            jdkBase = new File(jdkBase, "Home");
        }
        return jdkBase;
    }

    private String findPathToStandaloneJar(File libDirectory) throws BlackDuckIntegrationException {
        File standaloneJarFile = new File(libDirectory, STANDALONE_JAR_PATH);
        if (!standaloneJarFile.exists() || !standaloneJarFile.isFile()) {
            throw new BlackDuckIntegrationException(String.format("The standalone jar does not exist at: %s", standaloneJarFile.getAbsolutePath()));
        }
        return standaloneJarFile.getAbsolutePath();
    }

    private String findPathToScanCliJar(File libDirectory) throws BlackDuckIntegrationException {
        File scanCliJarFile = this.findFirstFilteredFile(libDirectory, SCAN_CLI_JAR_FILE_FILTER, "");
        if (!scanCliJarFile.exists() || !scanCliJarFile.isFile()) {
            throw new BlackDuckIntegrationException(String.format("The scan.cli jar does not exist at: %s", scanCliJarFile.getAbsolutePath()));
        }
        return scanCliJarFile.getAbsolutePath();
    }

    private File findFirstFilteredFile(File directory, FileFilter fileFilter, String notFoundMessageFormat) throws BlackDuckIntegrationException {
        File[] potentialItems = directory.listFiles(fileFilter);
        if (potentialItems == null || potentialItems.length < 1) {
            throw new BlackDuckIntegrationException(String.format(notFoundMessageFormat, directory.getAbsolutePath()));
        }
        return potentialItems[0];
    }

    private String determinePathToJavaExecutable(File jreContentsDirectory) throws BlackDuckIntegrationException {
        ThrowingSupplier javaHomeSupplier = () -> this.findPathToJavaExe(jreContentsDirectory);
        String bdsJavaHome = this.intEnvironmentVariables.getValue(BDS_JAVA_HOME);
        if (StringUtils.isNotBlank((CharSequence)bdsJavaHome)) {
            File bdsJavaHomeDirectory = new File(bdsJavaHome);
            if (bdsJavaHomeDirectory.exists() && bdsJavaHomeDirectory.isDirectory()) {
                javaHomeSupplier = () -> this.findPathToJavaExe(bdsJavaHomeDirectory);
            } else {
                String warningFormat = "The environment variable %s is set, but it cannot be used as a valid directory. It will be ignored and should either be corrected, or unset in the environment to avoid this warning.";
                this.logger.warn(String.format(warningFormat, BDS_JAVA_HOME));
            }
        }
        return (String)javaHomeSupplier.get();
    }

    public File getMetadataFile() {
        return this.scanCliMetadataFile;
    }
}

