/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.signaturescanner.command;

import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.BlackDuckOnlineProperties;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.IndividualFileMatching;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ReducedPersistence;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ScanCommandArgumentParser;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ScanPaths;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.rest.proxy.ProxyInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ScanCommand {
    private final String scheme;
    private final String host;
    private final int port;
    private final String targetPath;
    private final String name;
    private final Set<String> excludePatterns;
    private final BlackDuckOnlineProperties blackDuckOnlineProperties;
    private final String blackDuckUsername;
    private final String blackDuckPassword;
    private final String blackDuckApiToken;
    private final File signatureScannerInstallDirectory;
    private final File outputDirectory;
    private final int scanMemoryInMegabytes;
    private final String scanCliOpts;
    private final String additionalScanArguments;
    private final boolean runInsecure;
    private final boolean dryRun;
    private final ProxyInfo proxyInfo;
    private final String projectName;
    private final String versionName;
    private final IndividualFileMatching individualFileMatching;
    private final boolean debug;
    private final boolean verbose;
    private final boolean isRapid;
    private final ReducedPersistence reducedPersistence;
    @Nullable
    private final String correlationId;
    private final String bomCompareMode;
    private final boolean csvArchive;
    private final boolean scassScan;
    private List<String> command;
    private Map<String, List<Integer>> commandKeysToKeyRelatedIndices;

    public ScanCommand(File signatureScannerInstallDirectory, File outputDirectory, boolean dryRun, ProxyInfo proxyInfo, String scanCliOpts, int scanMemoryInMegabytes, String scheme, String host, String blackDuckApiToken, String blackDuckUsername, String blackDuckPassword, int port, boolean runInsecure, String name, BlackDuckOnlineProperties blackDuckOnlineProperties, IndividualFileMatching individualFileMatching, Set<String> excludePatterns, String additionalScanArguments, String targetPath, boolean verbose, boolean debug, String projectName, String versionName, boolean isRapid, ReducedPersistence reducedPersistence, @Nullable String correlationId, String bomCompareMode, boolean csvArchive, boolean scassScan) {
        this.signatureScannerInstallDirectory = signatureScannerInstallDirectory;
        this.outputDirectory = outputDirectory;
        this.dryRun = dryRun;
        this.proxyInfo = proxyInfo;
        this.scanCliOpts = scanCliOpts;
        this.scanMemoryInMegabytes = scanMemoryInMegabytes;
        this.scheme = scheme;
        this.host = host;
        this.blackDuckApiToken = blackDuckApiToken;
        this.blackDuckUsername = blackDuckUsername;
        this.blackDuckPassword = blackDuckPassword;
        this.port = port;
        this.runInsecure = runInsecure;
        this.name = name;
        this.blackDuckOnlineProperties = blackDuckOnlineProperties;
        this.individualFileMatching = individualFileMatching;
        this.excludePatterns = excludePatterns;
        this.additionalScanArguments = additionalScanArguments;
        this.targetPath = targetPath;
        this.verbose = verbose;
        this.debug = debug;
        this.projectName = projectName;
        this.versionName = versionName;
        this.isRapid = isRapid;
        this.reducedPersistence = reducedPersistence;
        this.correlationId = correlationId;
        this.bomCompareMode = bomCompareMode;
        this.csvArchive = csvArchive;
        this.scassScan = scassScan;
    }

    public List<String> createCommandForProcessBuilder(IntLogger logger, ScanPaths scannerPaths, String specificRunOutputDirectoryPath) throws IllegalArgumentException, IntegrationException {
        this.command = new ArrayList<String>();
        this.commandKeysToKeyRelatedIndices = new HashMap<String, List<Integer>>();
        logger.debug("Using this java installation : " + scannerPaths.getPathToJavaExecutable());
        scannerPaths.addJavaAndOnePathArguments(this.command);
        if (this.proxyInfo.shouldUseProxy()) {
            this.populateProxyDetails();
        }
        this.populateScanCliOpts();
        this.appendSingleArgument("-Xmx" + this.scanMemoryInMegabytes + "m");
        scannerPaths.addScanExecutableArguments(this.command);
        this.appendSingleArgument("--no-prompt");
        if (!this.dryRun) {
            this.populateOnlineProperties(logger);
        } else {
            this.populateOfflineProperties(logger, specificRunOutputDirectoryPath);
        }
        if (this.verbose) {
            this.appendSingleArgument("-v");
        }
        if (this.debug) {
            this.appendSingleArgument("--debug");
        }
        if (this.csvArchive) {
            if (this.dryRun) {
                this.appendKeyValuePair("--outputFormat", "csv");
            } else {
                this.appendSingleArgument("--upload-csv");
            }
        }
        this.appendKeyValuePair("--logDir", specificRunOutputDirectoryPath);
        this.appendKeyValuePair("--statusWriteDir", specificRunOutputDirectoryPath);
        this.populateProjectAndVersion();
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            this.appendKeyValuePair("--name", this.name);
        }
        this.populateExcludePatterns();
        if (null != this.individualFileMatching) {
            this.appendKeyValuePair("--individualFileMatching", this.individualFileMatching.toString());
        }
        if (this.isRapid) {
            this.appendSingleArgument("--no-persistence");
            this.appendKeyValuePair("--no-persistence-mode", this.bomCompareMode);
        }
        if (this.scassScan) {
            this.appendSingleArgument("--scass-scan");
        }
        this.populateReducedPersistence();
        if (StringUtils.isNotBlank((CharSequence)this.correlationId)) {
            this.appendKeyValuePair("--correlationId", this.correlationId);
        }
        ScanCommandArgumentParser parser = new ScanCommandArgumentParser();
        this.populateAdditionalScanArgumentsAndRemoveOverridden(parser);
        return this.command;
    }

    private void appendSingleArgument(String arg) {
        this.command.add(arg);
    }

    private void appendKeyValuePair(String key, String value) {
        if (!this.commandKeysToKeyRelatedIndices.containsKey(key)) {
            this.commandKeysToKeyRelatedIndices.put(key, new ArrayList());
        }
        List<Integer> indecesList = this.commandKeysToKeyRelatedIndices.get(key);
        indecesList.add(this.command.size());
        indecesList.add(this.command.size() + 1);
        this.appendSingleArgument(key);
        this.appendSingleArgument(value);
    }

    private void populateReducedPersistence() {
        if (this.reducedPersistence != null) {
            if (this.reducedPersistence.equals((Object)ReducedPersistence.DISCARD_UNMATCHED)) {
                this.appendSingleArgument("--discard-unmatched-files");
            }
            if (this.reducedPersistence.equals((Object)ReducedPersistence.RETAIN_UNMATCHED)) {
                this.appendSingleArgument("--retain-unmatched-files");
            }
        }
    }

    private void populateAdditionalScanArgumentsAndRemoveOverridden(ScanCommandArgumentParser parser) throws IntegrationException {
        HashSet overriddenArgIndices = new HashSet();
        List<String> arguments = parser.parse(this.additionalScanArguments);
        for (String argument : arguments) {
            if (!StringUtils.isNotBlank((CharSequence)argument)) continue;
            if (this.commandKeysToKeyRelatedIndices.containsKey(argument)) {
                overriddenArgIndices.addAll(this.commandKeysToKeyRelatedIndices.get(argument));
            }
            this.appendSingleArgument(argument);
        }
        if (!overriddenArgIndices.isEmpty()) {
            ArrayList<String> updatedCommand = new ArrayList<String>();
            for (int i = 0; i < this.command.size(); ++i) {
                if (overriddenArgIndices.contains(i)) continue;
                updatedCommand.add(this.command.get(i));
            }
            this.command = updatedCommand;
        }
    }

    private void populateExcludePatterns() {
        if (this.excludePatterns != null) {
            for (String exclusionPattern : this.excludePatterns) {
                if (!StringUtils.isNotBlank((CharSequence)exclusionPattern)) continue;
                this.appendKeyValuePair("--exclude", exclusionPattern);
            }
        }
    }

    private void populateProjectAndVersion() {
        if (StringUtils.isNotBlank((CharSequence)this.projectName) && StringUtils.isNotBlank((CharSequence)this.versionName)) {
            this.appendKeyValuePair("--project", this.projectName);
            this.appendKeyValuePair("--release", this.versionName);
        }
    }

    private void populateOfflineProperties(IntLogger logger, String specificRunOutputDirectoryPath) {
        logger.info("You have configured this signature scan to run in dry run mode - no results will be submitted to Black Duck.");
        this.blackDuckOnlineProperties.warnIfOnlineIsNeeded(arg_0 -> ((IntLogger)logger).warn(arg_0));
        this.appendKeyValuePair("--dryRunWriteDir", specificRunOutputDirectoryPath);
    }

    private void populateOnlineProperties(IntLogger logger) {
        int blackDuckPort;
        this.appendKeyValuePair("--scheme", this.scheme);
        this.appendKeyValuePair("--host", this.host);
        logger.debug("Using the Black Duck hostname : '" + this.host + "'");
        if (StringUtils.isEmpty((CharSequence)this.blackDuckApiToken)) {
            this.appendKeyValuePair("--username", this.blackDuckUsername);
        }
        if ((blackDuckPort = this.port) > 0) {
            this.appendKeyValuePair("--port", Integer.toString(blackDuckPort));
        } else {
            logger.warn("Could not find a port to use for the Server.");
        }
        if (this.runInsecure) {
            this.appendSingleArgument("--insecure");
        }
        this.blackDuckOnlineProperties.addOnlineCommands(this.command);
    }

    private void populateScanCliOpts() {
        if (StringUtils.isNotBlank((CharSequence)this.scanCliOpts)) {
            for (String scanOpt : this.scanCliOpts.split(" ")) {
                if (!StringUtils.isNotBlank((CharSequence)scanOpt)) continue;
                this.appendSingleArgument(scanOpt);
            }
        }
    }

    private void populateProxyDetails() {
        ProxyInfo blackDuckProxyInfo = this.proxyInfo;
        String proxyHost = blackDuckProxyInfo.getHost().orElse(null);
        int proxyPort = blackDuckProxyInfo.getPort();
        String proxyUsername = blackDuckProxyInfo.getUsername().orElse(null);
        String proxyPassword = blackDuckProxyInfo.getPassword().orElse(null);
        String proxyNtlmDomain = blackDuckProxyInfo.getNtlmDomain().orElse(null);
        String proxyNtlmWorkstation = blackDuckProxyInfo.getNtlmWorkstation().orElse(null);
        this.appendSingleArgument("-Dhttp.proxyHost=" + proxyHost);
        this.appendSingleArgument("-Dhttp.proxyPort=" + Integer.toString(proxyPort));
        if (StringUtils.isNotBlank((CharSequence)proxyUsername) && StringUtils.isNotBlank((CharSequence)proxyPassword)) {
            this.appendSingleArgument("-Dhttp.proxyUser=" + proxyUsername);
            this.appendSingleArgument("-Dhttp.proxyPassword=" + proxyPassword);
        } else {
            this.appendSingleArgument("-Dhttp.proxyUser=user");
            this.appendSingleArgument("-Dhttp.proxyPassword=password");
        }
        if (StringUtils.isNotBlank((CharSequence)proxyNtlmDomain)) {
            this.appendSingleArgument("-Dhttp.auth.ntlm.domain=" + proxyNtlmDomain);
        }
        if (StringUtils.isNotBlank((CharSequence)proxyNtlmWorkstation)) {
            this.appendSingleArgument("-Dblackduck.http.auth.ntlm.workstation=" + proxyNtlmWorkstation);
        }
    }

    public File getSignatureScannerInstallDirectory() {
        return this.signatureScannerInstallDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public String getScanCliOpts() {
        return this.scanCliOpts;
    }

    public int getScanMemoryInMegabytes() {
        return this.scanMemoryInMegabytes;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public String getBlackDuckApiToken() {
        return this.blackDuckApiToken;
    }

    public String getBlackDuckUsername() {
        return this.blackDuckUsername;
    }

    public String getBlackDuckPassword() {
        return this.blackDuckPassword;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunInsecure() {
        return this.runInsecure;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSnippetMatching() {
        return this.blackDuckOnlineProperties.isSnippetMatching();
    }

    public boolean isSnippetMatchingOnly() {
        return this.blackDuckOnlineProperties.isSnippetMatchingOnly();
    }

    public boolean isUploadSource() {
        return this.blackDuckOnlineProperties.isUploadSource();
    }

    public boolean isLicenseSearch() {
        return this.blackDuckOnlineProperties.isLicenseSearch();
    }

    public boolean isCopyrightSearch() {
        return this.blackDuckOnlineProperties.isCopyrightSearch();
    }

    public IndividualFileMatching getIndividualFileMatching() {
        return this.individualFileMatching;
    }

    public Set<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public String getAdditionalScanArguments() {
        return this.additionalScanArguments;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public boolean isRapid() {
        return this.isRapid;
    }

    public ReducedPersistence getReducedPersistence() {
        return this.reducedPersistence;
    }
}

