/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.signaturescanner.command;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;

public class ScanCliMetadata {
    @SerializedName(value="documentVersion")
    private String documentVersion;
    @SerializedName(value="toolVersion")
    private String toolVersion;
    @SerializedName(value="os")
    private String os;
    @SerializedName(value="arch")
    private String arch;

    public ScanCliMetadata() {
    }

    public ScanCliMetadata(String documentVersion, String toolVersion, String os, String arch) {
        this.documentVersion = documentVersion;
        this.toolVersion = toolVersion;
        this.os = os;
        this.arch = arch;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public String getOs() {
        return this.os;
    }

    public String getArch() {
        return this.arch;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public static ScanCliMetadata getMetadata(File metadataFile) throws IOException {
        Gson gson = new Gson();
        try (FileReader reader = new FileReader(metadataFile);){
            Type listType = new TypeToken<List<ScanCliMetadata>>(){}.getType();
            List metadataList = (List)gson.fromJson((Reader)reader, listType);
            if (metadataList != null && !metadataList.isEmpty()) {
                ScanCliMetadata scanCliMetadata = (ScanCliMetadata)metadataList.get(0);
                return scanCliMetadata;
            }
            throw new IOException("No metadata found in the file or file is empty");
        }
    }
}

