/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.signaturescanner;

import com.blackduck.integration.blackduck.codelocation.signaturescanner.ScanBatchBuilder;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.BlackDuckOnlineProperties;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.IndividualFileMatching;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ReducedPersistence;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ScanCommand;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ScanPathsUtility;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.ScanTarget;
import com.blackduck.integration.blackduck.codelocation.signaturescanner.command.SnippetMatching;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.builder.Buildable;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.proxy.ProxyInfo;
import com.blackduck.integration.util.IntEnvironmentVariables;
import com.blackduck.integration.util.Stringable;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class ScanBatch
extends Stringable
implements Buildable {
    private final boolean cleanupOutput;
    private final HttpUrl blackDuckUrl;
    private final BlackDuckOnlineProperties blackDuckOnlineProperties;
    private final List<ScanTarget> scanTargets;
    private final String blackDuckUsername;
    private final String blackDuckPassword;
    private final String blackDuckApiToken;
    private final File outputDirectory;
    private final int scanMemoryInMegabytes;
    private final String scanCliOpts;
    private final String additionalScanArguments;
    private final boolean runInsecure;
    private final boolean dryRun;
    private final ProxyInfo proxyInfo;
    private final String projectName;
    private final String projectVersionName;
    private final IndividualFileMatching individualFileMatching;
    private final boolean debug;
    private final boolean verbose;
    private final boolean isRapid;
    private final ReducedPersistence reducedPersistence;
    @Nullable
    private final String correlationId;
    private final String bomCompareMode;
    private final boolean csvArchive;
    private final boolean scassScan;

    public static ScanBatchBuilder newBuilder() {
        return new ScanBatchBuilder();
    }

    public ScanBatch(File outputDirectory, boolean cleanupOutput, int scanMemoryInMegabytes, boolean dryRun, boolean debug, boolean verbose, String scanCliOpts, String additionalScanArguments, BlackDuckOnlineProperties blackDuckOnlineProperties, IndividualFileMatching individualFileMatching, HttpUrl blackDuckUrl, String blackDuckUsername, String blackDuckPassword, String blackDuckApiToken, ProxyInfo proxyInfo, boolean runInsecure, String projectName, String projectVersionName, List<ScanTarget> scanTargets, boolean isRapid, ReducedPersistence reducedPersistence, @Nullable String correlationId, String bomCompareMode, boolean csvArchive, boolean scassScan) {
        this.outputDirectory = outputDirectory;
        this.cleanupOutput = cleanupOutput;
        this.scanMemoryInMegabytes = scanMemoryInMegabytes;
        this.dryRun = dryRun;
        this.debug = debug;
        this.verbose = verbose;
        this.scanCliOpts = scanCliOpts;
        this.additionalScanArguments = additionalScanArguments;
        this.blackDuckOnlineProperties = blackDuckOnlineProperties;
        this.individualFileMatching = individualFileMatching;
        this.blackDuckUrl = blackDuckUrl;
        this.blackDuckUsername = blackDuckUsername;
        this.blackDuckPassword = blackDuckPassword;
        this.blackDuckApiToken = blackDuckApiToken;
        this.proxyInfo = proxyInfo;
        this.runInsecure = runInsecure;
        this.projectName = projectName;
        this.projectVersionName = projectVersionName;
        this.scanTargets = scanTargets;
        this.isRapid = isRapid;
        this.reducedPersistence = reducedPersistence;
        this.correlationId = correlationId;
        this.bomCompareMode = bomCompareMode;
        this.csvArchive = csvArchive;
        this.scassScan = scassScan;
    }

    public List<ScanCommand> createScanCommands(File signatureScannerInstallDirectory, ScanPathsUtility scanPathsUtility, IntEnvironmentVariables intEnvironmentVariables) throws BlackDuckIntegrationException {
        String scanCliOptsEnvironment;
        String scanCliOptsToUse = this.scanCliOpts;
        if (null != intEnvironmentVariables && StringUtils.isBlank((CharSequence)scanCliOptsToUse) && StringUtils.isNotBlank((CharSequence)(scanCliOptsEnvironment = intEnvironmentVariables.getValue("SCAN_CLI_OPTS")))) {
            scanCliOptsToUse = scanCliOptsEnvironment;
        }
        boolean commandDryRun = this.blackDuckUrl == null || this.dryRun;
        String commandScheme = null;
        String commandHost = null;
        int commandPort = 0;
        if (!commandDryRun) {
            URL url = this.blackDuckUrl.url();
            commandScheme = url.getProtocol();
            commandHost = url.getHost();
            if (url.getPort() > 0) {
                commandPort = url.getPort();
            } else if (url.getDefaultPort() > 0) {
                commandPort = url.getDefaultPort();
            }
        }
        ArrayList<ScanCommand> scanCommands = new ArrayList<ScanCommand>();
        for (ScanTarget scanTarget : this.scanTargets) {
            this.addToScanCommands(signatureScannerInstallDirectory, scanPathsUtility, scanCliOptsToUse, commandDryRun, this.blackDuckOnlineProperties, commandScheme, commandHost, commandPort, scanCommands, scanTarget);
        }
        return scanCommands;
    }

    private void addToScanCommands(File signatureScannerInstallDirectory, ScanPathsUtility scanPathsUtility, String scanCliOptsToUse, boolean commandDryRun, BlackDuckOnlineProperties blackDuckOnlineProperties, String commandScheme, String commandHost, int commandPort, List<ScanCommand> scanCommands, ScanTarget scanTarget) throws BlackDuckIntegrationException {
        File commandOutputDirectory = scanTarget.determineCommandOutputDirectory(scanPathsUtility, this.outputDirectory);
        ScanCommand scanCommand = new ScanCommand(signatureScannerInstallDirectory, commandOutputDirectory, commandDryRun, this.proxyInfo, scanCliOptsToUse, this.scanMemoryInMegabytes, commandScheme, commandHost, this.blackDuckApiToken, this.blackDuckUsername, this.blackDuckPassword, commandPort, this.runInsecure, scanTarget.getCodeLocationName(), blackDuckOnlineProperties, this.individualFileMatching, scanTarget.getExclusionPatterns(), this.additionalScanArguments, scanTarget.getPath(), this.verbose, this.debug, this.projectName, this.projectVersionName, this.isRapid, this.reducedPersistence, this.correlationId, this.bomCompareMode, this.csvArchive, this.scassScan);
        scanCommands.add(scanCommand);
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isCleanupOutput() {
        return this.cleanupOutput;
    }

    public int getScanMemoryInMegabytes() {
        return this.scanMemoryInMegabytes;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getScanCliOpts() {
        return this.scanCliOpts;
    }

    public String getAdditionalScanArguments() {
        return this.additionalScanArguments;
    }

    public SnippetMatching getSnippetMatchingMode() {
        return this.blackDuckOnlineProperties.getSnippetMatchingMode();
    }

    public boolean isUploadSource() {
        return this.blackDuckOnlineProperties.isUploadSource();
    }

    public boolean isLicenseSearch() {
        return this.blackDuckOnlineProperties.isLicenseSearch();
    }

    public IndividualFileMatching getIndividualFileMatching() {
        return this.individualFileMatching;
    }

    public HttpUrl getBlackDuckUrl() {
        return this.blackDuckUrl;
    }

    public String getBlackDuckUsername() {
        return this.blackDuckUsername;
    }

    public String getBlackDuckPassword() {
        return this.blackDuckPassword;
    }

    public String getBlackDuckApiToken() {
        return this.blackDuckApiToken;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public boolean isRunInsecure() {
        return this.runInsecure;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersionName() {
        return this.projectVersionName;
    }

    public List<ScanTarget> getScanTargets() {
        return this.scanTargets;
    }

    public boolean isRapid() {
        return this.isRapid;
    }

    public ReducedPersistence getReducedPersistence() {
        return this.reducedPersistence;
    }

    @Nullable
    public String getCorrelationId() {
        return this.correlationId;
    }

    public boolean isCsvArchive() {
        return this.csvArchive;
    }

    public boolean isScassScan() {
        return this.scassScan;
    }
}

