/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.intelligentpersistence;

import com.blackduck.integration.blackduck.bdio2.Bdio2FileUploadService;
import com.blackduck.integration.blackduck.bdio2.Bdio2UploadResult;
import com.blackduck.integration.blackduck.codelocation.upload.UploadOutput;
import com.blackduck.integration.blackduck.codelocation.upload.UploadTarget;
import com.blackduck.integration.util.NameVersion;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Nullable;

public class IntelligentPersistenceCallable
implements Callable<UploadOutput> {
    private final Bdio2FileUploadService bdio2FileUploadService;
    private final UploadTarget uploadTarget;
    private final long timeout;
    private final long clientStartTime;

    public IntelligentPersistenceCallable(Bdio2FileUploadService bdio2FileUploadService, UploadTarget uploadTarget, long timeout, long clientStartTime) {
        this.bdio2FileUploadService = bdio2FileUploadService;
        this.uploadTarget = uploadTarget;
        this.timeout = timeout;
        this.clientStartTime = clientStartTime;
    }

    @Override
    public UploadOutput call() {
        @Nullable NameVersion projectAndVersion = this.uploadTarget.getProjectAndVersion().orElse(null);
        String codeLocationName = this.uploadTarget.getCodeLocationName();
        try {
            Bdio2UploadResult result = this.bdio2FileUploadService.uploadFile(this.uploadTarget, this.timeout, this.clientStartTime);
            return UploadOutput.SUCCESS(projectAndVersion, codeLocationName, null, result.getScanId());
        }
        catch (Exception ex) {
            String errorMessage = String.format("Failed to upload file: %s because %s", this.uploadTarget.getUploadFile().getAbsolutePath(), ex.getMessage());
            return UploadOutput.FAILURE(projectAndVersion, codeLocationName, errorMessage, ex);
        }
    }
}

