/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.intelligentpersistence;

import com.blackduck.integration.blackduck.bdio2.Bdio2FileUploadService;
import com.blackduck.integration.blackduck.codelocation.intelligentpersistence.IntelligentPersistenceCallable;
import com.blackduck.integration.blackduck.codelocation.upload.UploadBatch;
import com.blackduck.integration.blackduck.codelocation.upload.UploadBatchOutput;
import com.blackduck.integration.blackduck.codelocation.upload.UploadOutput;
import com.blackduck.integration.blackduck.codelocation.upload.UploadTarget;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class IntelligentPersistenceBatchRunner {
    private final IntLogger logger;
    private final ExecutorService executorService;
    private final Bdio2FileUploadService bdio2FileUploadService;

    public IntelligentPersistenceBatchRunner(IntLogger logger, ExecutorService executorService, Bdio2FileUploadService bdio2FileUploadService) {
        this.logger = logger;
        this.executorService = executorService;
        this.bdio2FileUploadService = bdio2FileUploadService;
    }

    public UploadBatchOutput executeUploads(UploadBatch uploadBatch, long timeout, long clientStartTime) throws BlackDuckIntegrationException {
        this.logger.info("Starting the codelocation file uploads.");
        UploadBatchOutput uploadBatchOutput = this.uploadTargets(uploadBatch, timeout, clientStartTime);
        this.logger.info("Completed the codelocation file uploads.");
        return uploadBatchOutput;
    }

    private UploadBatchOutput uploadTargets(UploadBatch uploadBatch, long timeout, long clientStartTime) throws BlackDuckIntegrationException {
        ArrayList<UploadOutput> uploadOutputs = new ArrayList<UploadOutput>();
        try {
            List<IntelligentPersistenceCallable> callables = this.createCallables(uploadBatch, timeout, clientStartTime);
            ArrayList<Future<UploadOutput>> submitted = new ArrayList<Future<UploadOutput>>();
            for (IntelligentPersistenceCallable intelligentPersistenceCallable : callables) {
                submitted.add(this.executorService.submit(intelligentPersistenceCallable));
            }
            for (Future future : submitted) {
                UploadOutput uploadOutput = (UploadOutput)future.get();
                uploadOutputs.add(uploadOutput);
            }
        }
        catch (Exception e) {
            throw new BlackDuckIntegrationException(String.format("Encountered a problem uploading a file: %s", e.getMessage()), e);
        }
        return new UploadBatchOutput((List<UploadOutput>)uploadOutputs);
    }

    private List<IntelligentPersistenceCallable> createCallables(UploadBatch uploadBatch, long timeout, long clientStartTime) {
        List<IntelligentPersistenceCallable> callables = uploadBatch.getUploadTargets().stream().map(uploadTarget -> new IntelligentPersistenceCallable(this.bdio2FileUploadService, (UploadTarget)uploadTarget, timeout, clientStartTime)).collect(Collectors.toList());
        return callables;
    }
}

