/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.binaryscanner;

import com.blackduck.integration.blackduck.api.core.response.UrlSingleResponse;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.codelocation.binaryscanner.BinaryScan;
import com.blackduck.integration.blackduck.codelocation.binaryscanner.BinaryScanOutput;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.request.BlackDuckResponseRequest;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.rest.exception.IntegrationRestException;
import com.blackduck.integration.rest.response.Response;
import com.blackduck.integration.util.NameVersion;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Callable;

public class BinaryScanCallable
implements Callable<BinaryScanOutput> {
    private final BlackDuckApiClient blackDuckApiClient;
    private final ApiDiscovery apiDiscovery;
    private final BinaryScan binaryScan;
    private final NameVersion projectAndVersion;
    private final String codeLocationName;

    public BinaryScanCallable(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, BinaryScan binaryScan) {
        this.blackDuckApiClient = blackDuckApiClient;
        this.apiDiscovery = apiDiscovery;
        this.binaryScan = binaryScan;
        this.projectAndVersion = new NameVersion(binaryScan.getProjectName(), binaryScan.getProjectVersion());
        this.codeLocationName = binaryScan.getCodeLocationName();
    }

    @Override
    public BinaryScanOutput call() {
        BinaryScanOutput binaryScanOutput;
        block9: {
            HashMap<String, String> textParts = new HashMap<String, String>();
            textParts.put("projectName", this.binaryScan.getProjectName());
            textParts.put("version", this.binaryScan.getProjectVersion());
            textParts.put("codeLocationName", this.binaryScan.getCodeLocationName());
            HashMap<String, File> binaryParts = new HashMap<String, File>();
            binaryParts.put("fileupload", this.binaryScan.getBinaryFile());
            UrlSingleResponse stringResponse = this.apiDiscovery.metaUploadsLink();
            BlackDuckResponseRequest request = new BlackDuckRequestBuilder().postMultipart(binaryParts, textParts).buildBlackDuckResponseRequest(stringResponse.getUrl());
            Response response = this.blackDuckApiClient.execute(request);
            try {
                binaryScanOutput = BinaryScanOutput.FROM_RESPONSE(this.projectAndVersion, this.codeLocationName, response);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IntegrationRestException e) {
                    return BinaryScanOutput.FROM_INTEGRATION_REST_EXCEPTION(this.projectAndVersion, this.codeLocationName, e);
                }
                catch (IntegrationException | IOException e) {
                    String errorMessage = String.format("Failed to upload binary file: %s because %s", this.binaryScan.getBinaryFile().getAbsolutePath(), e.getMessage());
                    return BinaryScanOutput.FAILURE(this.projectAndVersion, this.codeLocationName, errorMessage, (Exception)e);
                }
            }
            response.close();
        }
        return binaryScanOutput;
    }
}

