/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.binaryscanner;

import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.codelocation.binaryscanner.BinaryScan;
import com.blackduck.integration.blackduck.codelocation.binaryscanner.BinaryScanBatch;
import com.blackduck.integration.blackduck.codelocation.binaryscanner.BinaryScanBatchOutput;
import com.blackduck.integration.blackduck.codelocation.binaryscanner.BinaryScanCallable;
import com.blackduck.integration.blackduck.codelocation.binaryscanner.BinaryScanOutput;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class BinaryScanBatchRunner {
    private final IntLogger logger;
    private final BlackDuckApiClient blackDuckApiClient;
    private final ApiDiscovery apiDiscovery;
    private final ExecutorService executorService;

    public BinaryScanBatchRunner(IntLogger logger, BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, ExecutorService executorService) {
        this.logger = logger;
        this.blackDuckApiClient = blackDuckApiClient;
        this.apiDiscovery = apiDiscovery;
        this.executorService = executorService;
    }

    public BinaryScanBatchOutput executeUploads(BinaryScanBatch binaryScanBatch) throws BlackDuckIntegrationException {
        this.logger.info("Starting the binary scan file uploads.");
        BinaryScanBatchOutput binaryScanBatchOutput = this.uploadFiles(binaryScanBatch);
        this.logger.info("Completed the binary scan file uploads.");
        return binaryScanBatchOutput;
    }

    private BinaryScanBatchOutput uploadFiles(BinaryScanBatch binaryScanBatch) throws BlackDuckIntegrationException {
        ArrayList<BinaryScanOutput> uploadOutputs = new ArrayList<BinaryScanOutput>();
        try {
            List<BinaryScanCallable> callables = this.createCallables(binaryScanBatch);
            ArrayList<Future<BinaryScanOutput>> submitted = new ArrayList<Future<BinaryScanOutput>>();
            for (BinaryScanCallable binaryScanCallable : callables) {
                submitted.add(this.executorService.submit(binaryScanCallable));
            }
            for (Future future : submitted) {
                BinaryScanOutput uploadOutput = (BinaryScanOutput)future.get();
                uploadOutputs.add(uploadOutput);
            }
        }
        catch (Exception e) {
            throw new BlackDuckIntegrationException(String.format("Encountered a problem uploading a binary file: %s", e.getMessage()), e);
        }
        return new BinaryScanBatchOutput((List<BinaryScanOutput>)uploadOutputs);
    }

    private List<BinaryScanCallable> createCallables(BinaryScanBatch uploadBatch) {
        List<BinaryScanCallable> callables = uploadBatch.getBinaryScans().stream().map(binaryScan -> new BinaryScanCallable(this.blackDuckApiClient, this.apiDiscovery, (BinaryScan)binaryScan)).collect(Collectors.toList());
        return callables;
    }
}

