/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.bdiolegacy;

import com.blackduck.integration.blackduck.api.core.response.UrlSingleResponse;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.manual.response.BlackDuckStringResponse;
import com.blackduck.integration.blackduck.codelocation.upload.UploadOutput;
import com.blackduck.integration.blackduck.codelocation.upload.UploadTarget;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.request.BlackDuckResponseRequest;
import com.blackduck.integration.rest.response.Response;
import com.blackduck.integration.util.NameVersion;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.Nullable;

public class UploadCallable
implements Callable<UploadOutput> {
    private final BlackDuckApiClient blackDuckApiClient;
    private final ApiDiscovery apiDiscovery;
    private final UploadTarget uploadTarget;
    @Nullable
    private final NameVersion projectAndVersion;
    private final String codeLocationName;

    public UploadCallable(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, UploadTarget uploadTarget) {
        this.blackDuckApiClient = blackDuckApiClient;
        this.apiDiscovery = apiDiscovery;
        this.uploadTarget = uploadTarget;
        this.projectAndVersion = uploadTarget.getProjectAndVersion().orElse(null);
        this.codeLocationName = uploadTarget.getCodeLocationName();
    }

    @Override
    public UploadOutput call() {
        UploadOutput uploadOutput;
        block13: {
            String jsonPayload;
            try {
                jsonPayload = FileUtils.readFileToString((File)this.uploadTarget.getUploadFile(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                String errorMessage = String.format("Failed to initially read file: %s because %s", this.uploadTarget.getUploadFile().getAbsolutePath(), e.getMessage());
                return UploadOutput.FAILURE(this.projectAndVersion, this.codeLocationName, errorMessage, e);
            }
            UrlSingleResponse stringResponse = new UrlSingleResponse(this.apiDiscovery.metaBomImportLink().getUrl(), BlackDuckStringResponse.class);
            BlackDuckResponseRequest request = new BlackDuckRequestBuilder().postString(jsonPayload, ContentType.create((String)this.uploadTarget.getMediaType(), (Charset)StandardCharsets.UTF_8)).buildBlackDuckResponseRequest(stringResponse.getUrl());
            Response response = this.blackDuckApiClient.execute(request);
            try {
                String responseString = response.getContentString();
                uploadOutput = UploadOutput.SUCCESS(this.projectAndVersion, this.codeLocationName, responseString);
                if (response == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return UploadOutput.FAILURE(this.projectAndVersion, this.codeLocationName, e.getMessage(), e);
                    }
                }
                catch (Exception e) {
                    String errorMessage = String.format("Failed to upload file: %s because %s", this.uploadTarget.getUploadFile().getAbsolutePath(), e.getMessage());
                    return UploadOutput.FAILURE(this.projectAndVersion, this.codeLocationName, errorMessage, e);
                }
            }
            response.close();
        }
        return uploadOutput;
    }
}

