/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.bdiolegacy;

import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.codelocation.bdiolegacy.UploadCallable;
import com.blackduck.integration.blackduck.codelocation.upload.UploadBatch;
import com.blackduck.integration.blackduck.codelocation.upload.UploadBatchOutput;
import com.blackduck.integration.blackduck.codelocation.upload.UploadOutput;
import com.blackduck.integration.blackduck.codelocation.upload.UploadTarget;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class UploadBatchRunner {
    private final IntLogger logger;
    private final BlackDuckApiClient blackDuckApiClient;
    private final ApiDiscovery apiDiscovery;
    private final ExecutorService executorService;

    public UploadBatchRunner(IntLogger logger, BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, ExecutorService executorService) {
        this.logger = logger;
        this.blackDuckApiClient = blackDuckApiClient;
        this.apiDiscovery = apiDiscovery;
        this.executorService = executorService;
    }

    public UploadBatchOutput executeUploads(UploadBatch uploadBatch) throws BlackDuckIntegrationException {
        this.logger.info("Starting the codelocation file uploads.");
        UploadBatchOutput uploadBatchOutput = this.uploadTargets(uploadBatch);
        this.logger.info("Completed the codelocation file uploads.");
        return uploadBatchOutput;
    }

    private UploadBatchOutput uploadTargets(UploadBatch uploadBatch) throws BlackDuckIntegrationException {
        ArrayList<UploadOutput> uploadOutputs = new ArrayList<UploadOutput>();
        try {
            List<UploadCallable> callables = this.createCallables(uploadBatch);
            ArrayList<Future<UploadOutput>> submitted = new ArrayList<Future<UploadOutput>>();
            for (UploadCallable uploadCallable : callables) {
                submitted.add(this.executorService.submit(uploadCallable));
            }
            for (Future future : submitted) {
                UploadOutput uploadOutput = (UploadOutput)future.get();
                uploadOutputs.add(uploadOutput);
            }
        }
        catch (Exception e) {
            throw new BlackDuckIntegrationException(String.format("Encountered a problem uploading a file: %s", e.getMessage()), e);
        }
        return new UploadBatchOutput((List<UploadOutput>)uploadOutputs);
    }

    private List<UploadCallable> createCallables(UploadBatch uploadBatch) {
        List<UploadCallable> callables = uploadBatch.getUploadTargets().stream().map(uploadTarget -> new UploadCallable(this.blackDuckApiClient, this.apiDiscovery, (UploadTarget)uploadTarget)).collect(Collectors.toList());
        return callables;
    }
}

