/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.bdio2legacy;

import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.codelocation.upload.UploadOutput;
import com.blackduck.integration.blackduck.codelocation.upload.UploadTarget;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.request.BlackDuckRequestBuilderEditor;
import com.blackduck.integration.blackduck.service.request.BlackDuckResponseRequest;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.response.Response;
import com.blackduck.integration.util.NameVersion;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.Nullable;

public class UploadBdio2Callable
implements Callable<UploadOutput> {
    private final BlackDuckApiClient blackDuckApiClient;
    private final ApiDiscovery apiDiscovery;
    private final UploadTarget uploadTarget;
    @Nullable
    private final NameVersion projectAndVersion;
    private final String codeLocationName;
    private final BlackDuckRequestBuilderEditor editor;

    public UploadBdio2Callable(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, UploadTarget uploadTarget, BlackDuckRequestBuilderEditor editor) {
        this.blackDuckApiClient = blackDuckApiClient;
        this.apiDiscovery = apiDiscovery;
        this.uploadTarget = uploadTarget;
        this.projectAndVersion = uploadTarget.getProjectAndVersion().orElse(null);
        this.codeLocationName = uploadTarget.getCodeLocationName();
        this.editor = editor;
    }

    @Override
    public UploadOutput call() {
        try {
            HttpUrl url = this.apiDiscovery.metaSingleResponse(BlackDuckApiClient.SCAN_DATA_PATH).getUrl();
            BlackDuckResponseRequest request = new BlackDuckRequestBuilder().postFile(this.uploadTarget.getUploadFile(), ContentType.create((String)this.uploadTarget.getMediaType(), (Charset)StandardCharsets.UTF_8)).apply(this.editor).buildBlackDuckResponseRequest(url);
            return this.executeRequest(request);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to upload file: %s because %s", this.uploadTarget.getUploadFile().getAbsolutePath(), e.getMessage());
            return UploadOutput.FAILURE(this.projectAndVersion, this.codeLocationName, errorMessage, e);
        }
    }

    private UploadOutput executeRequest(BlackDuckResponseRequest request) throws IOException {
        UploadOutput uploadOutput;
        block8: {
            Response response = this.blackDuckApiClient.execute(request);
            try {
                String responseString = response.getContentString();
                uploadOutput = UploadOutput.SUCCESS(this.projectAndVersion, this.codeLocationName, responseString);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IntegrationException e) {
                    return UploadOutput.FAILURE(this.projectAndVersion, this.codeLocationName, e.getMessage(), (Exception)((Object)e));
                }
            }
            response.close();
        }
        return uploadOutput;
    }
}

