/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation.bdio2legacy;

import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.codelocation.bdio2legacy.UploadBdio2Callable;
import com.blackduck.integration.blackduck.codelocation.upload.UploadBatch;
import com.blackduck.integration.blackduck.codelocation.upload.UploadBatchOutput;
import com.blackduck.integration.blackduck.codelocation.upload.UploadOutput;
import com.blackduck.integration.blackduck.codelocation.upload.UploadTarget;
import com.blackduck.integration.blackduck.exception.BlackDuckIntegrationException;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.request.BlackDuckRequestBuilderEditor;
import com.blackduck.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class UploadBdio2BatchRunner {
    private final IntLogger logger;
    private final BlackDuckApiClient blackDuckApiClient;
    private final ApiDiscovery apiDiscovery;
    private final ExecutorService executorService;

    public UploadBdio2BatchRunner(IntLogger logger, BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, ExecutorService executorService) {
        this.logger = logger;
        this.blackDuckApiClient = blackDuckApiClient;
        this.apiDiscovery = apiDiscovery;
        this.executorService = executorService;
    }

    public UploadBatchOutput executeUploads(UploadBatch uploadBatch) throws BlackDuckIntegrationException {
        this.logger.info("Starting the codelocation file uploads.");
        UploadBatchOutput uploadBatchOutput = this.uploadTargets(uploadBatch);
        this.logger.info("Completed the codelocation file uploads.");
        return uploadBatchOutput;
    }

    private UploadBatchOutput uploadTargets(UploadBatch uploadBatch) throws BlackDuckIntegrationException {
        ArrayList<UploadOutput> uploadOutputs = new ArrayList<UploadOutput>();
        try {
            List<UploadBdio2Callable> callables = this.createCallables(uploadBatch);
            ArrayList<Future<UploadOutput>> submitted = new ArrayList<Future<UploadOutput>>();
            for (UploadBdio2Callable uploadBdio2Callable : callables) {
                submitted.add(this.executorService.submit(uploadBdio2Callable));
            }
            for (Future future : submitted) {
                UploadOutput uploadOutput = (UploadOutput)future.get();
                uploadOutputs.add(uploadOutput);
            }
        }
        catch (Exception e) {
            throw new BlackDuckIntegrationException(String.format("Encountered a problem uploading a file: %s", e.getMessage()), e);
        }
        return new UploadBatchOutput((List<UploadOutput>)uploadOutputs);
    }

    private List<UploadBdio2Callable> createCallables(UploadBatch uploadBatch) {
        return uploadBatch.getUploadTargets().stream().map(uploadTarget -> new UploadBdio2Callable(this.blackDuckApiClient, this.apiDiscovery, (UploadTarget)uploadTarget, this.createEditor((UploadTarget)uploadTarget))).collect(Collectors.toList());
    }

    private BlackDuckRequestBuilderEditor createEditor(UploadTarget uploadTarget) {
        return uploadTarget.getProjectAndVersion().map(projectVersion -> builder -> builder.addHeader("X-BD-PROJECT-NAME", projectVersion.getName()).addHeader("X-BD-VERSION-NAME", projectVersion.getVersion())).orElse(noOp -> {});
    }
}

