/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation;

import com.blackduck.integration.blackduck.api.generated.view.UserView;
import com.blackduck.integration.blackduck.codelocation.CodeLocationWaitJob;
import com.blackduck.integration.blackduck.codelocation.CodeLocationWaitResult;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.dataservice.NotificationService;
import com.blackduck.integration.blackduck.service.dataservice.ProjectService;
import com.blackduck.integration.blackduck.service.model.NotificationTaskRange;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.util.NameVersion;
import com.blackduck.integration.wait.ResilientJob;
import com.blackduck.integration.wait.ResilientJobConfig;
import com.blackduck.integration.wait.ResilientJobExecutor;
import com.blackduck.integration.wait.tracker.WaitIntervalTracker;
import com.blackduck.integration.wait.tracker.WaitIntervalTrackerFactory;
import java.util.Set;

public class CodeLocationWaiter {
    private final IntLogger logger;
    private final BlackDuckApiClient blackDuckApiClient;
    private final ProjectService projectService;
    private final NotificationService notificationService;

    public CodeLocationWaiter(IntLogger logger, BlackDuckApiClient blackDuckApiClient, ProjectService projectService, NotificationService notificationService) {
        this.logger = logger;
        this.blackDuckApiClient = blackDuckApiClient;
        this.projectService = projectService;
        this.notificationService = notificationService;
    }

    public CodeLocationWaitResult checkCodeLocationsAddedToBom(UserView userView, NotificationTaskRange notificationTaskRange, NameVersion projectAndVersion, Set<String> codeLocationNames, int expectedNotificationCount, long timeoutInSeconds, int waitIntervalInSeconds) throws IntegrationException, InterruptedException {
        this.logger.debug("Expected notification count " + expectedNotificationCount);
        this.logger.debug("Expected code locations:");
        codeLocationNames.forEach(codeLocation -> this.logger.debug(String.format("  Code Location -> %s", codeLocation)));
        this.logger.debug("");
        WaitIntervalTracker waitIntervalTracker = WaitIntervalTrackerFactory.createConstant((long)timeoutInSeconds, (long)waitIntervalInSeconds);
        ResilientJobConfig jobConfig = new ResilientJobConfig(this.logger, notificationTaskRange.getTaskStartTime(), waitIntervalTracker);
        CodeLocationWaitJob codeLocationWaitJob = new CodeLocationWaitJob(this.logger, this.projectService, this.notificationService, userView, notificationTaskRange, projectAndVersion, codeLocationNames, expectedNotificationCount, this.blackDuckApiClient);
        ResilientJobExecutor resilientJobExecutor = new ResilientJobExecutor(jobConfig);
        return (CodeLocationWaitResult)resilientJobExecutor.executeJob((ResilientJob)codeLocationWaitJob);
    }
}

