/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation;

import java.util.Optional;
import java.util.Set;

public class CodeLocationWaitResult {
    private final Status status;
    private final Set<String> codeLocationNames;
    private final String errorMessage;

    public static CodeLocationWaitResult COMPLETE(Set<String> codeLocationNames) {
        return new CodeLocationWaitResult(Status.COMPLETE, codeLocationNames, null);
    }

    public static CodeLocationWaitResult PARTIAL(Set<String> codeLocationNames, String errorMessage) {
        return new CodeLocationWaitResult(Status.PARTIAL, codeLocationNames, errorMessage);
    }

    public CodeLocationWaitResult(Status status, Set<String> codeLocationNames, String errorMessage) {
        this.status = status;
        this.codeLocationNames = codeLocationNames;
        this.errorMessage = errorMessage;
    }

    public Status getStatus() {
        return this.status;
    }

    public Set<String> getCodeLocationNames() {
        return this.codeLocationNames;
    }

    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }

    public static enum Status {
        COMPLETE,
        PARTIAL;

    }
}

