/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation;

import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionView;
import com.blackduck.integration.blackduck.api.generated.view.UserView;
import com.blackduck.integration.blackduck.api.manual.component.VersionBomCodeLocationBomComputedNotificationContent;
import com.blackduck.integration.blackduck.api.manual.enumeration.NotificationType;
import com.blackduck.integration.blackduck.api.manual.view.NotificationUserView;
import com.blackduck.integration.blackduck.api.manual.view.VersionBomCodeLocationBomComputedNotificationUserView;
import com.blackduck.integration.blackduck.codelocation.CodeLocationsRetriever;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.dataservice.NotificationService;
import com.blackduck.integration.blackduck.service.dataservice.ProjectService;
import com.blackduck.integration.blackduck.service.model.NotificationTaskRange;
import com.blackduck.integration.blackduck.service.model.ProjectVersionWrapper;
import com.blackduck.integration.blackduck.service.request.NotificationEditor;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.util.NameVersion;
import com.blackduck.integration.wait.WaitJobCondition;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CodeLocationWaitJobCondition
implements WaitJobCondition {
    private final IntLogger logger;
    private final ProjectService projectService;
    private final NotificationService notificationService;
    private final UserView userView;
    private final NotificationTaskRange notificationTaskRange;
    private final NameVersion projectAndVersion;
    private final Set<String> codeLocationNames;
    private final int expectedNotificationCount;
    private final CodeLocationsRetriever codeLocationsRetriever;
    private final Set<String> foundCodeLocationNames = new HashSet<String>();

    public CodeLocationWaitJobCondition(IntLogger logger, BlackDuckApiClient blackDuckApiClient, ProjectService projectService, NotificationService notificationService, UserView userView, NotificationTaskRange notificationTaskRange, NameVersion projectAndVersion, Set<String> codeLocationNames, int expectedNotificationCount) {
        this.logger = logger;
        this.projectService = projectService;
        this.notificationService = notificationService;
        this.userView = userView;
        this.notificationTaskRange = notificationTaskRange;
        this.projectAndVersion = projectAndVersion;
        this.codeLocationNames = codeLocationNames;
        this.expectedNotificationCount = expectedNotificationCount;
        this.codeLocationsRetriever = new CodeLocationsRetriever(blackDuckApiClient);
    }

    public boolean isComplete() throws IntegrationException {
        boolean complete;
        int actualNotificationCount = this.retrieveCompletedCount(this.userView, this.notificationTaskRange);
        boolean bl = complete = this.foundCodeLocationNames.containsAll(this.codeLocationNames) && actualNotificationCount >= this.expectedNotificationCount;
        if (!complete) {
            this.logger.info("All code locations have not been added to the BOM yet...");
        }
        return complete;
    }

    public Set<String> getFoundCodeLocationNames() {
        return this.foundCodeLocationNames;
    }

    private int retrieveCompletedCount(UserView userView, NotificationTaskRange notificationTaskRange) throws IntegrationException {
        Optional<ProjectVersionWrapper> projectVersionWrapper = this.projectService.getProjectVersion(this.projectAndVersion);
        if (!projectVersionWrapper.isPresent()) {
            return 0;
        }
        ProjectVersionView projectVersionView = projectVersionWrapper.get().getProjectVersionView();
        Map<String, String> foundCodeLocations = this.codeLocationsRetriever.retrieveCodeLocations(projectVersionView, this.codeLocationNames);
        int actualNotificationCount = 0;
        if (foundCodeLocations.size() > 0) {
            this.logger.debug("At least one code location has been found, now looking for notifications.");
            List<VersionBomCodeLocationBomComputedNotificationUserView> notifications = this.getFilteredNotificationUserViews(userView, notificationTaskRange);
            this.logger.debug(String.format("There were %d notifications found.", notifications.size()));
            for (VersionBomCodeLocationBomComputedNotificationUserView notification : notifications) {
                String codeLocationUrl = ((VersionBomCodeLocationBomComputedNotificationContent)notification.getContent()).getCodeLocation();
                if (!foundCodeLocations.containsKey(codeLocationUrl)) continue;
                String codeLocationName = foundCodeLocations.get(codeLocationUrl);
                this.foundCodeLocationNames.add(codeLocationName);
                this.logger.info(String.format("Found %s code location (%d of %d).", codeLocationName, ++actualNotificationCount, this.expectedNotificationCount));
            }
        }
        return actualNotificationCount;
    }

    private List<VersionBomCodeLocationBomComputedNotificationUserView> getFilteredNotificationUserViews(UserView userView, NotificationTaskRange notificationTaskRange) throws IntegrationException {
        Date startDate = notificationTaskRange.getStartDate();
        Date endDate = notificationTaskRange.getEndDate();
        List<String> typesToInclude = Arrays.asList(NotificationType.VERSION_BOM_CODE_LOCATION_BOM_COMPUTED.name());
        NotificationEditor notificationEditor = new NotificationEditor(startDate, endDate, typesToInclude);
        List<NotificationUserView> notifications = this.notificationService.getAllUserNotifications(userView, notificationEditor);
        return notifications.stream().map(VersionBomCodeLocationBomComputedNotificationUserView.class::cast).collect(Collectors.toList());
    }
}

