/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation;

import com.blackduck.integration.blackduck.api.core.response.UrlSingleResponse;
import com.blackduck.integration.blackduck.api.generated.discovery.ApiDiscovery;
import com.blackduck.integration.blackduck.api.generated.view.UserView;
import com.blackduck.integration.blackduck.codelocation.CodeLocationBatchOutput;
import com.blackduck.integration.blackduck.codelocation.CodeLocationCreationData;
import com.blackduck.integration.blackduck.codelocation.CodeLocationCreationRequest;
import com.blackduck.integration.blackduck.codelocation.CodeLocationWaitResult;
import com.blackduck.integration.blackduck.codelocation.CodeLocationWaiter;
import com.blackduck.integration.blackduck.service.BlackDuckApiClient;
import com.blackduck.integration.blackduck.service.DataService;
import com.blackduck.integration.blackduck.service.dataservice.NotificationService;
import com.blackduck.integration.blackduck.service.dataservice.UserService;
import com.blackduck.integration.blackduck.service.model.NotificationTaskRange;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.util.NameVersion;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Optional;
import java.util.Set;

public class CodeLocationCreationService
extends DataService {
    public static final int DEFAULT_WAIT_INTERVAL_IN_SECONDS = 60;
    private final CodeLocationWaiter codeLocationWaiter;
    private final NotificationService notificationService;
    private final UserService userService;

    public CodeLocationCreationService(BlackDuckApiClient blackDuckApiClient, ApiDiscovery apiDiscovery, IntLogger logger, CodeLocationWaiter codeLocationWaiter, NotificationService notificationService, UserService userService) {
        super(blackDuckApiClient, apiDiscovery, logger);
        this.codeLocationWaiter = codeLocationWaiter;
        this.notificationService = notificationService;
        this.userService = userService;
    }

    public <T extends CodeLocationBatchOutput<?>> CodeLocationCreationData<T> createCodeLocations(CodeLocationCreationRequest<T> codeLocationCreationRequest) throws IntegrationException {
        NotificationTaskRange notificationTaskRange = this.calculateCodeLocationRange();
        T output = codeLocationCreationRequest.executeRequest();
        return new CodeLocationCreationData<T>(notificationTaskRange, output);
    }

    public <T extends CodeLocationBatchOutput<?>> T createCodeLocationsAndWait(CodeLocationCreationRequest<T> codeLocationCreationRequest, long timeoutInSeconds) throws IntegrationException, InterruptedException {
        return this.createCodeLocationsAndWait(codeLocationCreationRequest, timeoutInSeconds, 60);
    }

    public <T extends CodeLocationBatchOutput<?>> T createCodeLocationsAndWait(CodeLocationCreationRequest<T> codeLocationCreationRequest, long timeoutInSeconds, int waitIntervalInSeconds) throws IntegrationException, InterruptedException {
        CodeLocationCreationData<T> codeLocationCreationData = this.createCodeLocations(codeLocationCreationRequest);
        NotificationTaskRange notificationTaskRange = codeLocationCreationData.getNotificationTaskRange();
        T output = codeLocationCreationData.getOutput();
        Optional<NameVersion> projectAndVersion = ((CodeLocationBatchOutput)output).getProjectAndVersion();
        if (projectAndVersion.isPresent()) {
            this.waitForCodeLocations(notificationTaskRange, projectAndVersion.get(), ((CodeLocationBatchOutput)output).getSuccessfulCodeLocationNames(), ((CodeLocationBatchOutput)output).getExpectedNotificationCount(), timeoutInSeconds, waitIntervalInSeconds);
        } else {
            this.logger.info("Cannot wait for a code location that is not mapped to a project version. Skipping.");
        }
        return output;
    }

    public CodeLocationWaitResult waitForCodeLocations(NotificationTaskRange notificationTaskRange, NameVersion projectAndVersion, Set<String> codeLocationNames, int expectedNotificationCount, long timeoutInSeconds) throws IntegrationException, InterruptedException {
        return this.waitForCodeLocations(notificationTaskRange, projectAndVersion, codeLocationNames, expectedNotificationCount, timeoutInSeconds, 60);
    }

    public CodeLocationWaitResult waitForCodeLocations(NotificationTaskRange notificationTaskRange, NameVersion projectAndVersion, Set<String> codeLocationNames, int expectedNotificationCount, long timeoutInSeconds, int waitIntervalInSeconds) throws IntegrationException, InterruptedException {
        UserView currentUser = this.userService.findCurrentUser();
        return this.codeLocationWaiter.checkCodeLocationsAddedToBom(currentUser, notificationTaskRange, projectAndVersion, codeLocationNames, expectedNotificationCount, timeoutInSeconds, waitIntervalInSeconds);
    }

    public NotificationTaskRange calculateCodeLocationRange() throws IntegrationException {
        long startTime = System.currentTimeMillis();
        LocalDateTime localStartTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(startTime), ZoneOffset.UTC);
        LocalDateTime threeDaysLater = localStartTime.plusDays(3L);
        UrlSingleResponse userResponse = this.apiDiscovery.metaSingleResponse(ApiDiscovery.CURRENT_USER_PATH);
        UserView currentUser = (UserView)this.blackDuckApiClient.getResponse(userResponse);
        Date startDate = this.notificationService.getLatestUserNotificationDate(currentUser);
        Date endDate = Date.from(threeDaysLater.atZone(ZoneOffset.UTC).toInstant());
        return new NotificationTaskRange(startTime, startDate, endDate);
    }
}

