/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.codelocation;

import com.blackduck.integration.blackduck.codelocation.CodeLocationOutput;
import com.blackduck.integration.blackduck.codelocation.Result;
import com.blackduck.integration.util.NameVersion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class CodeLocationBatchOutput<T extends CodeLocationOutput>
implements Iterable<T> {
    private final Map<String, Integer> successfulCodeLocationNamesToExpectedNotificationCounts;
    private final List<T> outputs = new ArrayList<T>();

    public CodeLocationBatchOutput(List<T> outputs) {
        this.successfulCodeLocationNamesToExpectedNotificationCounts = outputs.stream().peek(this.outputs::add).filter(output -> Result.SUCCESS == output.getResult()).filter(output -> StringUtils.isNotBlank((CharSequence)output.getCodeLocationName())).collect(Collectors.toMap(CodeLocationOutput::getCodeLocationName, CodeLocationOutput::getExpectedNotificationCount));
    }

    public List<T> getOutputs() {
        return this.outputs;
    }

    public Optional<NameVersion> getProjectAndVersion() {
        return this.outputs.stream().map(CodeLocationOutput::getProjectAndVersion).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Set<String> getSuccessfulCodeLocationNames() {
        return this.successfulCodeLocationNamesToExpectedNotificationCounts.keySet();
    }

    public int getExpectedNotificationCount() {
        return this.successfulCodeLocationNamesToExpectedNotificationCounts.values().stream().mapToInt(Integer::intValue).sum();
    }

    public boolean hasAnyFailures() {
        return this.outputs.stream().map(CodeLocationOutput::getResult).anyMatch(Result.FAILURE::equals);
    }

    @Override
    public Iterator<T> iterator() {
        return this.outputs.iterator();
    }
}

